<?php
add_action( 'elementor/element/section/section_structure/after_section_end', 'agria_add_custom_section_controls' );
add_action( 'elementor/element/column/layout/after_section_end', 'agria_add_custom_columns_controls' );
function agria_add_custom_section_controls( \Elementor\Element_Base $element) {

	$element->start_controls_section(
		'section_pxl',
		[
			'label' => esc_html__( 'Agria Settings', 'agria' ),
			'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
		]
	);

	$element->add_control(
		'header_layout_type',
		[
			'label'   => esc_html__( 'Header Layout Type', 'agria' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'options' => array(
                'none'        => esc_html__( 'None', 'agria' ),
                'clip'   => esc_html__( 'Clip', 'agria' ),
            ),
            'prefix_class' => 'pxl-type-header-',
            'default'      => 'none',
		]
	);


	$element->add_control(
		'pxl_color_offset',
		[
			'label'   => esc_html__( 'Background - Left Space', 'agria' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'options' => array(
                'none'        => esc_html__( 'No', 'agria' ),
                'left'   => esc_html__( 'Yes', 'agria' ),
            ),
            'prefix_class' => 'pxl-bg-color-',
            'default'      => 'none',
		]
	);

	$element->add_control(
		'offset_color',
		[
			'label' => esc_html__('Background Color', 'agria' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-bg-color-left:before' => 'background-color: {{VALUE}};',
            ],
            'condition' => [
                'pxl_color_offset' => ['left'],
            ],
		]
	);
	$element->add_control(
		'row_divider',
		[
			'label'   => esc_html__( 'Divider', 'agria' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'options' => array(
                ''        => esc_html__( 'None', 'agria' ),
                'angle-top'   => esc_html__( 'Angle Top', 'agria' ),
            ),
            'prefix_class' => 'pxl-row-divider-',
            'default'      => '',
		]
	);

	$element->add_control(
		'divider_color',
		[
			'label' => esc_html__('Divider Color', 'agria' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-row-divider-angle-top .pxl-row-angle' => 'fill: {{VALUE}};',
            ],
            'condition' => [
                'row_divider' => ['angle-top'],
            ],
		]
	);

	$element->add_control(
	    'pxl_section_padding_60',
	    [
	      'label' => esc_html__( 'Section Padding 60px', 'agria' ),
	      'type'         => \Elementor\Controls_Manager::SELECT,
	            'prefix_class' => 'pxl-section-padding-',
	            'hide_in_inner' => true,
	            'options'      => array(
	                'none'    => esc_html__( 'None', 'agria' ),
	                '60'   => esc_html__( '60px', 'agria' ),
	            ),
	            'default'      => 'none',
	            'condition' => [
	                'layout' => 'full_width'
	            ]
	    ]
	  );

	$element->add_control(
	    'pxl_section_offset',
	    [
	      'label' => esc_html__( 'Section Offset', 'agria' ),
	      'type'         => \Elementor\Controls_Manager::SELECT,
	            'prefix_class' => 'pxl-section-offset-',
	            'hide_in_inner' => true,
	            'options'      => array(
	                'none'    => esc_html__( 'None', 'agria' ),
	                'left'   => esc_html__( 'Left', 'agria' ),
	                'right'     => esc_html__( 'Right', 'agria' ),
	            ),
	            'default'      => 'none',
	            'condition' => [
	                'layout' => 'full_width'
	            ]
	    ]
	  );

	  $element->add_control(
	    'pxl_container_width',
	    [
	            'label' => esc_html__( 'Container Width', 'agria' ),
	            'type'         => \Elementor\Controls_Manager::SELECT,
	            'prefix_class' => 'pxl-container-width-',
	            'hide_in_inner' => true,
	            'options'      => array(
	                'container-1200'    => esc_html__( '1200px', 'agria' ),
	                'container-1400'    => esc_html__( '1400px', 'agria' ),
	                'container-925'    => esc_html__( '925px', 'agria' )
	            ),
	            'default'      => 'container-1200',
	            'condition' => [
	                'layout' => 'full_width',
	                'pxl_section_offset!' => 'none'
	            ]
	    ]
	);

	$element->add_control(
		'row_scroll_fixed',
		[
	        'label'   => esc_html__( 'Row Scroll - Column Fixed', 'agria' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'options' => array(
                'none'        => esc_html__( 'No', 'agria' ),
                'fixed'   => esc_html__( 'Yes', 'agria' ),
            ),
            'prefix_class' => 'pxl-row-scroll-',
            'default'      => 'none',
		]
	);

	$element->add_control(
		'pxl_section_bg',
		[
			'label'   => esc_html__( 'Background Type', 'agria' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'options' => array(
                'none'     => esc_html__( 'No', 'agria' ),
                'normal'   => esc_html__( 'Normal', 'agria' ),
                'overlay'  => esc_html__( 'Overlay', 'agria' ),
            ),
            'prefix_class' => 'pxl-section-bg-',
            'default'      => 'none',
            'separator'    => 'before',
		]
	);

	$element->add_control(
		'pxl_section_bg_light',
		[
	        'label'   	=> esc_html__( 'Background - Light', 'agria' ),
            'type' 	  	=> \Elementor\Controls_Manager::COLOR,
            'selectors' => [
            	'{{WRAPPER}}' => 'background-color: {{VALUE}};',
            ],
            'condition' => [
                'pxl_section_bg' => ['normal'],
            ],
		]
	);

	$element->add_control(
		'pxl_section_bg_dark',
		[
	        'label'   	=> esc_html__( 'Background - Dark', 'agria' ),
            'type' 	  	=> \Elementor\Controls_Manager::COLOR,
            'selectors' => [
            	'.dark-mode {{WRAPPER}}' => 'background-color: {{VALUE}};',
            ],
            'condition' => [
                'pxl_section_bg' => ['normal'],
            ],
		]
	);

	$element->add_control(
		'pxl_section_overlay_light',
		[
	        'label'   	=> esc_html__( 'Background Overlay - Light', 'agria' ),
            'type' 	  	=> \Elementor\Controls_Manager::COLOR,
            'selectors' => [
            	'{{WRAPPER}}:before' => 'background-color: {{VALUE}};',
            ],
            'condition' => [
                'pxl_section_bg' => ['overlay'],
            ],
		]
	);

	$element->add_control(
		'pxl_section_overlay_dark',
		[
	        'label'   	=> esc_html__( 'Background Overlay - Dark', 'agria' ),
            'type' 	  	=> \Elementor\Controls_Manager::COLOR,
            'selectors' => [
            	'.dark-mode {{WRAPPER}}:before' => 'background-color: {{VALUE}};',
            ],
            'condition' => [
                'pxl_section_bg' => ['overlay'],
            ],
		]
	);


	$element->end_controls_section();
};

function agria_add_custom_columns_controls( \Elementor\Element_Base $element) {
	$element->start_controls_section(
		'columns_pxl',
		[
			'label' => esc_html__( 'Agria Settings', 'agria' ),
			'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
		]
	);
	$element->add_control(
		'col_line',
		[
            'label'   => esc_html__( 'Column Line Style', 'agria' ),
			'type'    => \Elementor\Controls_Manager::SELECT,
			'options' => array(
				'none'           => esc_html__( 'None', 'agria' ),
                'line1'           => esc_html__( 'Line 1', 'agria' ),
                'line2'           => esc_html__( 'Line 2', 'agria' ),
            ),
            'default' => 'none',
            'prefix_class' => 'pxl-col-'
		]
	);

	$element->add_control(
		'col_line_color',
		[
			'label' => esc_html__('Column Line Color', 'agria' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}}.pxl-col-line2:before' => 'background-color: {{VALUE}};',
            ],
            'condition' => [
                'col_line' => ['line2'],
            ],
		]
	);

	$element->add_control(
		'col_line_height',
		[
			'label' => esc_html__('Column Line Height', 'agria' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'control_type' => 'responsive',
            'size_units' => [ 'px', '%' ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 3000,
                ],
            ],
            'selectors' => [
                '{{WRAPPER}}.pxl-col-line2:before' => 'height: {{SIZE}}{{UNIT}};',
            ],
            'separator' => 'after',
            'condition' => [
                'col_line' => ['line2'],
            ],
		]
	);

	$element->add_control(
		'col_content_align',
		[
            'label'   => esc_html__( 'Column Content Align', 'agria' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'options' => array(
                ''           => esc_html__( 'Default', 'agria' ),
                'start'           => esc_html__( 'Start', 'agria' ),
                'center'           => esc_html__( 'Center', 'agria' ),
                'end'           => esc_html__( 'End', 'agria' ),
            ),
            'default' => '',
            'prefix_class' => 'pxl-col-align-'
		]
	);

	$element->add_control(
		'col_sticky',
		[
            'label'   => esc_html__( 'Column Sticky', 'agria' ),
			'type'    => \Elementor\Controls_Manager::SELECT,
			'options' => array(
				'none'           => esc_html__( 'No', 'agria' ),
				'sticky' => esc_html__( 'Yes', 'agria' ),
            ),
            'default' => 'none',
            'prefix_class' => 'pxl-column-'
		]
	);

	$element->add_control(
		'pxl_col_bg_light',
		[
	        'label'   	=> esc_html__( 'Column Background - Light', 'agria' ),
            'type' 	  	=> \Elementor\Controls_Manager::COLOR,
            'selectors' => [
            	'{{WRAPPER}}' => 'background-color: {{VALUE}};',
            ],
		]
	);

	$element->add_control(
		'pxl_col_bg_dark',
		[
	        'label'   	=> esc_html__( 'Column Background - Dark', 'agria' ),
            'type' 	  	=> \Elementor\Controls_Manager::COLOR,
            'selectors' => [
            	'.dark-mode {{WRAPPER}}' => 'background-color: {{VALUE}};',
            ],
		]
	);

	$element->end_controls_section();
}


add_action( 'elementor/element/after_add_attributes', 'agria_custom_el_attributes', 10, 1 );
function agria_custom_el_attributes($el){
    if( 'section' !== $el->get_name() ) {
        return;
    }
    $settings = $el->get_settings();
}

add_action( 'elementor/element/column/layout/before_section_end', 'add_responsive_column_order', 10, 3 );
function add_responsive_column_order( $element, $args ) {
	$element->add_responsive_control(
		'responsive_column_order',
		[
			'label'   => esc_html__( 'Column Order', 'agria' ),
			'type' => \Elementor\Controls_Manager::NUMBER,
			'separator' => 'before',
			'selectors' => [
				'{{WRAPPER}}' => '-webkit-order: {{VALUE}}; -ms-flex-order: {{VALUE}}; order: {{VALUE}};',
			],
		]
	);
}