<?php
    if(!function_exists('agria_get_post_grid')){
    function agria_get_post_grid($posts = [], $settings = []){
        if (empty($posts) || !is_array($posts) || empty($settings) || !is_array($settings)) {
            return false;
        }
        switch ($settings['layout']) {
            case 'post-1':
                agria_get_post_grid_layout1($posts, $settings);
                break;

            case 'portfolio-1':
                agria_get_portfolio_grid_layout1($posts, $settings);
                break;

            case 'service-1':
                agria_get_service_grid_layout1($posts, $settings);
                break;
            case 'service-2':
                agria_get_service_grid_layout2($posts, $settings);
                break;

            default:
                return false;
                break;
        }
    }
}

// Start Post Grid
//--------------------------------------------------
function agria_get_post_grid_layout1($posts = [], $settings = []){
    extract($settings);
    $images_size = !empty($img_size) ? $img_size : '1200x822';
    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                $col_xl_m = $grid_masonry[$key]['col_xl_m'];
                $col_lg_m = $grid_masonry[$key]['col_lg_m'];
                $col_md_m = $grid_masonry[$key]['col_md_m'];
                $col_sm_m = $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";

                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else
                $filter_class = '';

            $img_id = get_post_thumbnail_id($post->ID);
            if($img_id) {
                $img = pxl_get_image_by_size( array(
                    'attach_id'  => $img_id,
                    'thumb_size' => $images_size,
                    'class' => 'no-lazyload',
                ));
                $thumbnail = $img['thumbnail'];
            } else {
                $thumbnail = get_the_post_thumbnail($post->ID, $images_size);
            }
            $author = get_user_by('id', $post->post_author); ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-item--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): ?>
                        <div class="item--featured">
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo wp_kses_post($thumbnail); ?></a>
                        </div>
                    <?php endif; ?>
                    <div class="item--holder">
                        <?php if($show_category == 'true' || $show_date == 'true' ) : ?>
                            <ul class="item--meta">
                                <?php if($show_category == 'true'): ?>
                                    <li class="item--category"><?php the_terms( $post->ID, 'category', '', ' , ' ); ?></li>
                                <?php endif; ?>
                                <?php if($show_date == 'true'): ?>
                                    <li class="item--date"><?php $date_formart = get_option('date_format'); echo get_the_date($date_formart, $post->ID); ?></li>
                                <?php endif; ?>
                            </ul>
                        <?php endif; ?>
                        <h5 class="item--title"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_attr(get_the_title($post->ID)); ?></a></h5>
                        <?php if ($show_excerpt == 'true' && !empty($post->post_excerpt)) : ?>
                            <div class="item--excerpt <?php if(!empty($text_line)) { echo esc_attr__( 'pxl-text-line', 'agria' ); } ?>" <?php if(!empty($text_line)) { ?>style="-webkit-line-clamp: <?php echo esc_attr($text_line); ?>"<?php } ?>>
                                <?php echo wp_trim_words( $post->post_excerpt, $num_words, $more = null ); ?>
                            </div>
                        <?php endif; ?>
                        <?php if($show_button == 'true') : ?>
                            <a class="pxl-btn-line pxl-transtion" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                <span class="pxl-wobble">
                                    <?php if(!empty($button_text)) {
                                        $btn_text = $button_text;
                                        } else {
                                            $btn_text = esc_html__('Read More', 'agria');
                                        }
                                        $words = explode(' ', $btn_text);
                                        foreach ($words as $word) {
                                            echo '<span>' . htmlspecialchars($word) . '</span> ';
                                        }
                                    ?>
                                </span>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php
        endforeach;
    endif;
}
// End Post Grid
//--------------------------------------------------

// Start Portfolio Grid
//--------------------------------------------------
function agria_get_portfolio_grid_layout1($posts = [], $settings = []){
    extract($settings);

    $images_size = !empty($img_size) ? $img_size : '902x602';

    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                $col_xl_m = $grid_masonry[$key]['col_xl_m'];
                $col_lg_m = $grid_masonry[$key]['col_lg_m'];
                $col_md_m = $grid_masonry[$key]['col_md_m'];
                $col_sm_m = $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";

                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else
                $filter_class = '';

            $img_id = get_post_thumbnail_id($post->ID);
            if($img_id) {
                $img = pxl_get_image_by_size( array(
                    'attach_id'  => $img_id,
                    'thumb_size' => $images_size,
                    'class' => 'no-lazyload',
                ));
                $thumbnail = $img['thumbnail'];
            } else {
                $thumbnail = get_the_post_thumbnail($post->ID, $images_size);
            } ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-item--inner pxl-grid-item-inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)):
                    $thumbnail_url = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false); ?>
                        <div class="pxl-item-featured">
                            <?php echo wp_kses_post($thumbnail); ?>
                        </div>
                    <?php endif; ?>
                    <div class="pxl-item--front">
                        <div class="pxl-item-content">
                            <h5 class="pxl-item-title"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_attr(get_the_title($post->ID)); ?></a></h5>
                            <span class="pxl-item-tags"><?php the_terms( $post->ID, 'portfolio-tag', '', ', ' ); ?></span>
                        </div>
                        <span class="pxl-item-icon pxl-related-front"><i class="fal fa-plus"></i></span>
                    </div>
                    <div class="pxl-item--bg bg-image" style="background-image: url(<?php echo esc_url($thumbnail_url[0]); ?>);"></div>
                    <div class="pxl-item--back">
                        <div class="pxl-content-main">
                            <h5 class="pxl-item-title"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_attr(get_the_title($post->ID)); ?></a></h5>
                            <span class="pxl-item-date"><?php $date_formart = get_option('date_format'); echo get_the_date($date_formart, $post->ID); ?></span>
                            <?php if (!empty($post->post_excerpt)) : ?>
                                <div class="pxl-item--excerpt">
                                    <?php echo wp_trim_words( $post->post_excerpt, 15, $more = null ); ?>
                                </div>
                            <?php endif; ?>
                            <span class="pxl-item--author">
                                <?php echo get_avatar( get_the_author_meta( 'ID' ), 160 ); ?>
                                <?php the_author_posts_link(); ?>
                            </span>
                        </div>
                        <span class="pxl-item-icon pxl-related-back"><i class="fal fa-minus "></i></span>
                    </div>
                </div>
            </div>
        <?php
        endforeach;
    endif;
}

// End Portfolio Grid

// Start Service Grid
//--------------------------------------------------
function agria_get_service_grid_layout1($posts = [], $settings = []){
    extract($settings);

    $images_size = !empty($img_size) ? $img_size : '420x600';

    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                $col_xl_m = $grid_masonry[$key]['col_xl_m'];
                $col_lg_m = $grid_masonry[$key]['col_lg_m'];
                $col_md_m = $grid_masonry[$key]['col_md_m'];
                $col_sm_m = $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";

                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else
                $filter_class = '';

            $service_excerpt = get_post_meta($post->ID, 'service_excerpt', true);
            $service_external_link = get_post_meta($post->ID, 'service_external_link', true);
            $service_icon_type = get_post_meta($post->ID, 'service_icon_type', true);
            $service_icon_font = get_post_meta($post->ID, 'service_icon_font', true);
            $service_icon_img = get_post_meta($post->ID, 'service_icon_img', true);
            ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-item--inner pxl-not-active <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                    <div class="pxl-item--holder">
                        <?php if($service_icon_type == 'icon' && !empty($service_icon_font)) : ?>
                            <div class="pxl-item--icon">
                                <i class="<?php echo esc_attr($service_icon_font); ?>"></i>
                            </div>
                        <?php endif; ?>
                        <?php if($service_icon_type == 'image' && !empty($service_icon_img)) :
                            $icon_img = pxl_get_image_by_size( array(
                                'attach_id'  => $service_icon_img['id'],
                                'thumb_size' => 'full',
                            ));
                            $icon_thumbnail = $icon_img['thumbnail'];
                            ?>
                            <div class="pxl-item--icon">
                                <?php echo wp_kses_post($icon_thumbnail); ?>
                            </div>
                        <?php endif; ?>
                        <div class="pxl-item--content">
                            <h4 class="item--title">
                                <a class="pxl-transtion" href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>"><?php echo esc_attr(get_the_title($post->ID)); ?></a>
                            </h4>
                            <?php if($show_excerpt == 'true' && !empty($service_excerpt)): ?>
                                <div class="item--excerpt">
                                    <?php echo wp_trim_words( $service_excerpt, $num_words, $more = null ); ?>
                                </div>
                            <?php endif; ?>
                            <?php if($show_button == 'true') : ?>
                                <a class="pxl-btn-line pxl-transtion" href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                    <span class="pxl-wobble">
                                        <?php if(!empty($button_text)) {
                                            $btn_text = $button_text;
                                        } else {
                                            $btn_text = esc_html__('Read More', 'agria');
                                        }
                                        $words = explode(' ', $btn_text);
                                        foreach ($words as $word) {
                                            echo '<span>' . htmlspecialchars($word) . '</span> ';
                                        }
                                        ?>
                                    </span>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php
        endforeach;
    endif;
}
function agria_get_service_grid_layout2($posts = [], $settings = []){
    extract($settings);

    $images_size = !empty($img_size) ? $img_size : '420x600';

    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                $col_xl_m = $grid_masonry[$key]['col_xl_m'];
                $col_lg_m = $grid_masonry[$key]['col_lg_m'];
                $col_md_m = $grid_masonry[$key]['col_md_m'];
                $col_sm_m = $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";

                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else
                $filter_class = '';

            $service_excerpt = get_post_meta($post->ID, 'service_excerpt', true);
            $service_external_link = get_post_meta($post->ID, 'service_external_link', true);
            $service_icon_type = get_post_meta($post->ID, 'service_icon_type', true);
            $service_icon_font = get_post_meta($post->ID, 'service_icon_font', true);
            $service_icon_img = get_post_meta($post->ID, 'service_icon_img', true);
            ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-item--inner pxl-not-active <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                    <div class="item-direction">
                        <div class="pxl-item--holder">
                            <?php if($service_icon_type == 'icon' && !empty($service_icon_font)) : ?>
                                <div class="pxl-item--icon pxl-transtion">
                                    <i class="<?php echo esc_attr($service_icon_font); ?>"></i>
                                </div>
                            <?php endif; ?>
                            <?php if($service_icon_type == 'image' && !empty($service_icon_img)) :
                                $icon_img = pxl_get_image_by_size( array(
                                    'attach_id'  => $service_icon_img['id'],
                                    'thumb_size' => 'full',
                                ));
                                $icon_thumbnail = $icon_img['thumbnail'];
                                ?>
                                <div class="pxl-item--icon pxl-transtion">
                                    <?php echo wp_kses_post($icon_thumbnail); ?>
                                </div>
                            <?php endif; ?>
                            <div class="pxl-item--content">
                                <h5 class="item--title">
                                    <a class="pxl-transtion" href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>"><?php echo esc_attr(get_the_title($post->ID)); ?></a>
                                </h5>
                                <?php if($show_excerpt == 'true' && !empty($service_excerpt)): ?>
                                    <div class="item--excerpt pxl-transtion">
                                        <?php echo wp_trim_words( $service_excerpt, $num_words, $more = null ); ?>
                                    </div>
                                <?php endif; ?>
                                <?php if($show_button == 'true') : ?>
                                    <a class="pxl-button pxl-transtion" href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                        <span class="pxl--btn-text">
                                            <?php if(!empty($button_text)) {
                                                echo pxl_print_html($button_text);
                                            } else {
                                                echo pxl_print_html('Read More', 'agria');
                                            } ?>
                                        </span>
                                    </a>
                                <?php endif; ?>
                            </div>
                            <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)):
                                $img_id       = get_post_thumbnail_id( $post->ID );
                                $img          = agria_get_image_by_size( array(
                                    'attach_id'  => $img_id,
                                    'thumb_size' => $images_size
                                ) );
                                $thumbnail    = $img['url']; ?>
                                <div class="pxl-bg--image" style="background-image: url(<?php echo wp_kses_post($thumbnail); ?>);"></div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php
        endforeach;
    endif;
}
// End Service Grid
//--------------------------------------------------

add_action( 'wp_ajax_agria_get_pagination_html', 'agria_get_pagination_html' );
add_action( 'wp_ajax_nopriv_agria_get_pagination_html', 'agria_get_pagination_html' );
function agria_get_pagination_html(){
    try{
        if(!isset($_POST['query_vars'])){
            throw new Exception(__('Something went wrong while requesting. Please try again!', 'agria'));
        }
        $query = new WP_Query($_POST['query_vars']);
        ob_start();
        agria()->page->get_pagination( $query,  true );
        $html = ob_get_clean();
        wp_send_json(
            array(
                'status' => true,
                'message' => esc_attr__('Load Successfully!', 'agria'),
                'data' => array(
                    'html' => $html,
                    'query_vars' => $_POST['query_vars'],
                    'post' => $query->have_posts()
                ),
            )
        );
    }
    catch (Exception $e){
        wp_send_json(array('status' => false, 'message' => $e->getMessage()));
    }
    die;
}

add_action( 'wp_ajax_agria_load_more_product_grid', 'agria_load_more_product_grid' );
add_action( 'wp_ajax_nopriv_agria_load_more_product_grid', 'agria_load_more_product_grid' );
function agria_load_more_product_grid(){
    try{
        if(!isset($_POST['settings'])){
            throw new Exception(__('Something went wrong while requesting. Please try again!', 'agria'));
        }
        $settings = $_POST['settings'];
        set_query_var('paged', $settings['paged']);
        $query_type         = isset($settings['query_type']) ? $settings['query_type'] : 'recent_product';
        $post_per_page      = isset($settings['limit']) ? $settings['limit'] : 8;
        $product_ids        = isset($settings['product_ids']) ? $settings['product_ids'] : '';
        $categories         = isset($settings['categories']) ? $settings['categories'] : '';
        $param_args         = isset($settings['param_args']) ? $settings['param_args'] : [];

        $col_xxl = isset($settings['col_xxl']) ? 'col-xxl-'.str_replace('.', '',12 / floatval($settings['col_xxl'])) : '';
        $col_xl = isset($settings['col_xl']) ? 'col-xl-'.str_replace('.', '',12 / floatval( $settings['col_xl'])) : '';
        $col_lg = isset($settings['col_lg']) ? 'col-lg-'.str_replace('.', '',12 / floatval( $settings['col_lg'])) : '';
        $col_md = isset($settings['col_md']) ? 'col-md-'.str_replace('.', '',12 / floatval( $settings['col_md'])) : '';
        $col_sm = isset($settings['col_sm']) ? 'col-sm-'.str_replace('.', '',12 / floatval( $settings['col_sm'])) : '';
        $col_xs = isset($settings['col_xs']) ? 'col-'.str_replace('.', '',12 / floatval( $settings['col_xs'])) : '';

        $item_class = trim(implode(' ', ['pxl-grid-item', $col_xxl, $col_xl, $col_lg, $col_md, $col_sm, $col_xs]));

        $loop = agria_woocommerce_query($query_type,$post_per_page,$product_ids,$categories,$param_args);
        extract($loop);

        $data_animation = [];
        $animate_cls = '';
        $data_settings = '';
        if ( !empty( $settings['item_animation'] ) ) {
            $animate_cls = ' pxl-animate pxl-invisible animated-'.$settings['item_animation_duration'];
            $data_animation['animation'] = $settings['item_animation'];
            $data_animation['animation_delay'] = $settings['item_animation_delay'];
        }
        if($posts->have_posts()){
            ob_start();
                $d = 0;
                while ($posts->have_posts()) {
                    $posts->the_post();
                    global $product;
                    $d++;
                    $term_list = array();
                    $term_of_post = wp_get_post_terms($product->get_ID(), 'product_cat');
                    foreach ($term_of_post as $term) {
                        $term_list[] = $term->slug;
                    }
                    $filter_class = implode(' ', $term_list);

                    if ( !empty( $data_animation ) ) {
                        $data_animation['animation_delay'] = ((float)$settings['item_animation_delay'] * $d);
                        $data_animations = json_encode($data_animation);
                        $data_settings = 'data-settings="'.esc_attr($data_animations).'"';
                    }

                    ?>
                    <div class="<?php echo trim(implode(' ', [$item_class, $filter_class, $animate_cls])); ?>" <?php pxl_print_html($data_settings); ?>>
                        <?php
                            do_action( 'woocommerce_before_shop_loop_item' );
                            do_action( 'woocommerce_before_shop_loop_item_title' );
                            do_action( 'woocommerce_shop_loop_item_title' );
                            do_action( 'woocommerce_after_shop_loop_item_title' );
                            do_action( 'woocommerce_after_shop_loop_item' );
                        ?>
                    </div>
                <?php
                }
                if($settings['layout_mode'] == 'masonry')
                    echo '<div class="grid-sizer '.$item_class.'"></div>';
            $html = ob_get_clean();
            wp_send_json(
                array(
                    'status' => true,
                    'message' => esc_html__('Load Post Grid Successfully!', 'agria'),
                    'data' => array(
                        'html'  => $html,
                        'paged' => $settings['paged'],
                        'posts' => $posts,
                        'max' => $max,
                    ),
                )
            );
        }else{
            wp_send_json(
                array(
                    'status' => false,
                    'message' => esc_html__('Load Post Grid No More!', 'agria')
                )
            );
        }
    }
    catch (Exception $e){
        wp_send_json(array('status' => false, 'message' => $e->getMessage()));
    }
    die;
}

add_action( 'wp_ajax_agria_load_more_post_grid', 'agria_load_more_post_grid' );
add_action( 'wp_ajax_nopriv_agria_load_more_post_grid', 'agria_load_more_post_grid' );
function agria_load_more_post_grid(){
    try{
        if(!isset($_POST['settings'])){
            throw new Exception(__('Something went wrong while requesting. Please try again!', 'agria'));
        }
        $settings = $_POST['settings'];
        set_query_var('paged', $settings['paged']);
        extract(pxl_get_posts_of_grid($settings['post_type'], [
            'source' => isset($settings['source'])?$settings['source']:'',
            'orderby' => isset($settings['orderby'])?$settings['orderby']:'date',
            'order' => isset($settings['order'])?$settings['order']:'desc',
            'limit' => isset($settings['limit'])?$settings['limit']:'6',
            'post_ids' => isset($settings['post_ids'])?$settings['post_ids']:[],
        ]));
        ob_start();

        agria_get_post_grid($posts, $settings);
        $html = ob_get_clean();
        wp_send_json(
            array(
                'status' => true,
                'message' => esc_attr__('Load Successfully!', 'agria'),
                'data' => array(
                    'html' => $html,
                    'paged' => $settings['paged'],
                    'posts' => $posts,
                    'max' => $max,
                ),
            )
        );
    }
    catch (Exception $e){
        wp_send_json(array('status' => false, 'message' => $e->getMessage()));
    }
    die;
}