<?php
$editor_title = $widget->get_settings_for_display( 'title' );
$editor_title = $widget->parse_text_editor( $editor_title );

if ( ! empty( $settings['btn_link']['url'] ) ) {
    $widget->add_render_attribute( 'btn_link', 'href', $settings['btn_link']['url'] );

    if ( $settings['btn_link']['is_external'] ) {
        $widget->add_render_attribute( 'btn_link', 'target', '_blank' );
    }
    if ( $settings['btn_link']['nofollow'] ) {
        $widget->add_render_attribute( 'btn_link', 'rel', 'nofollow' );
    }
}

$img_size = '';
if(!empty($settings['img_size'])) {
    $img_size = $settings['img_size'];
} else {
    $img_size = 'full';
}
?>
<div class="pxl-banner-box pxl-banner-box1 <?php echo esc_attr($settings['style']); ?> <?php if($settings['show_button'] == 'true') { echo 'pxl-show-button'; } ?> <?php echo 'type-'.esc_attr($settings['bg_type']); ?>">
    <div class="pxl-item--inner" <?php if ( $settings['bg_type'] == 'bg' && !empty($settings['image']['id']) ) { ?>style="background-image: url(<?php echo esc_url($settings['image']['url']); ?>);"<?php } ?>>

        <?php if( $settings['style'] == 'style2' && ! empty( $settings['btn_link']['url'] ) ) : ?>
            <a <?php pxl_print_html($widget->get_render_attribute_string( 'btn_link' )); ?>>
        <?php endif; ?>

        <?php if( $settings['bg_type'] == 'img' && !empty( $settings['image']['id'] ) ) :
            $img = pxl_get_image_by_size( array(
                'attach_id'  => $settings['image']['id'],
                'thumb_size' => $img_size,
            ) );
            $thumbnail = $img['thumbnail'];
            ?>
            <div class="pxl-item--image">
                <?php echo wp_kses_post($thumbnail); ?>
            </div>
        <?php endif; ?>
        <div class="pxl-item--content <?php echo esc_attr($settings['content_position']); ?>">
            <?php if(!empty($settings['sub_title'])) : ?>
                <div class="pxl-item--subtitle <?php echo esc_attr($settings['pxl_animate_sub']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay_sub']); ?>ms" data-wow-duration="<?php echo esc_attr($settings['pxl_animate_duration_sub']); ?>s"><span><?php echo esc_attr($settings['sub_title']); ?></span></div>
            <?php endif; ?>
            <<?php echo esc_attr($settings['title_tag']); ?> class="pxl-item--title <?php if($settings['pxl_animate'] !== 'wow letter') { echo esc_attr($settings['pxl_animate']); } ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms" data-wow-duration="<?php echo esc_attr($settings['pxl_animate_duration']); ?>s">
                <?php if(!empty($editor_title)) :
                    if($settings['pxl_animate'] == 'wow letter') {
                        $arr_str = explode(' ', $editor_title); ?>
                        <span class="pxl-item--text">
                            <?php foreach ($arr_str as $index => $value) {
                                $arr_str[$index] = '<span class="pxl-text--slide"><span class="'.$settings['pxl_animate'].'">' . $value . '</span></span>';
                            }
                            $str = implode(' ', $arr_str);
                            echo wp_kses_post($str); ?>
                        </span>
                    <?php } else {
                        echo wp_kses_post($editor_title);
                    }
                endif; ?>
            </<?php echo esc_attr($settings['title_tag']); ?>>
            <?php if(!empty($settings['description'])) : ?>
                <div class="pxl-item--description <?php echo esc_attr($settings['pxl_animate_description']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay_description']); ?>ms" data-wow-duration="<?php echo esc_attr($settings['pxl_animate_duration_description']); ?>s"><span><?php echo esc_attr($settings['description']); ?></span></div>
            <?php endif; ?>
            <?php if($settings['show_button'] == 'true' && $settings['style'] == 'style1') : ?>
                <a class="btn btn-default <?php echo esc_attr($settings['pxl_animate_button']); ?>" <?php pxl_print_html($widget->get_render_attribute_string( 'btn_link' )); ?> data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay_button']); ?>ms" data-wow-duration="<?php echo esc_attr($settings['pxl_animate_duration_button']); ?>s">
                    <span class="pxl-wobble" data-animation="pxl-xspin">
                        <?php if(!empty($settings['btn_text'])) {
                            $btn_text = $settings['btn_text'];
                        } else {
                            $btn_text = pxl_print_html('Shop Now', 'agria');
                        }
                        $words = explode(' ', $btn_text);
                        foreach ($words as $word) {
                            echo '<span>' . htmlspecialchars($word) . '</span> ';
                        }
                        ?>
                    </span>
                </a>
            <?php endif; ?>
        </div>
        <?php if($settings['show_button'] == 'true' && $settings['style'] == 'style2') : ?>
            <div class="pxl-item--content <?php echo esc_attr($settings['content_position']); ?> content-back">
                <<?php echo esc_attr($settings['title_tag']); ?> class="pxl-item--title pxl-wobble" data-animation="pxl-upscale">
                    <?php if(!empty($settings['btn_text'])) {
                        $btn_text = $settings['btn_text'];
                    } else {
                        $btn_text = pxl_print_html('Shop Now', 'agria');
                    }
                    $words = explode(' ', $btn_text);
                    foreach ($words as $word) {
                        echo '<span>' . htmlspecialchars($word) . '</span> ';
                    }
                    ?>
                </<?php echo esc_attr($settings['title_tag']); ?>>
            </div>
        <?php endif; ?>

        <?php if( $settings['style'] == 'style2' && ! empty( $settings['btn_link']['url'] ) ) : ?>
        </a>
        <?php endif; ?>
    </div>
</div>