<?php
$editor_title = $widget->get_settings_for_display( 'title' );
$editor_title = $widget->parse_text_editor( $editor_title );

$month = esc_html__('Month', 'agria');
$months = esc_html__('Months', 'agria');
$day = $widget->get_setting('day','Day');
$days = $widget->get_setting('day','Days');
$hour = $widget->get_setting('hour','Hour');
$hours = $widget->get_setting('hour','Hours');
$minute = $widget->get_setting('minute','Minute');
$minutes = $widget->get_setting('minute','Minutes');
$second = $widget->get_setting('second','Second');
$seconds = $widget->get_setting('second','Seconds');
?>
<div class="pxl-countdown2 pxl-countdown-wrap" <?php if ( !empty($settings['image']['id']) ) { ?>style="background-image: url(<?php echo esc_url($settings['image']['url']); ?>);"<?php } ?> data-cursor="-hidden">
	<<?php echo esc_attr($settings['title_tag']); ?> class="pxl-item--title <?php if($settings['pxl_animate_title'] !== 'wow letter') { echo esc_attr($settings['pxl_animate_title']); } ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay_title']); ?>ms" data-wow-duration="<?php echo esc_attr($settings['pxl_animate_duration_title']); ?>s">
		<?php if(!empty($editor_title)) :
			if($settings['pxl_animate_title'] == 'wow letter') {
				$arr_str = explode(' ', $editor_title); ?>
				<span class="pxl-item--text">
					<?php foreach ($arr_str as $index => $value) {
						$arr_str[$index] = '<span class="pxl-text--slide"><span class="'.$settings['pxl_animate_title'].'">' . $value . '</span></span>';
					}
					$str = implode(' ', $arr_str);
					echo wp_kses_post($str); ?>
				</span>
			<?php } else {
				echo wp_kses_post($editor_title);
			}
		endif; ?>
	</<?php echo esc_attr($settings['title_tag']); ?>>
	<div class="pxl-countdown pxl-countdown-layout2 <?php echo esc_attr( $settings['show_svg'].' '.$settings['pxl_animate'] ); ?>"
		data-month="<?php echo esc_attr($month) ?>"
		data-months="<?php echo esc_attr($months) ?>"
		data-day="<?php echo esc_attr($day) ?>"
		data-days="<?php echo esc_attr($days) ?>"
		data-hour="<?php echo esc_attr($hour) ?>"
		data-hours="<?php echo esc_attr($hours) ?>"
		data-minute="<?php echo esc_attr($minute) ?>"
		data-minutes="<?php echo esc_attr($minutes) ?>"
		data-second="<?php echo esc_attr($second) ?>"
		data-seconds="<?php echo esc_attr($seconds) ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms" data-wow-duration="<?php echo esc_attr($settings['pxl_animate_duration']); ?>s">
		<div class="pxl-countdown-inner" data-count-down="<?php echo esc_attr($settings['date']);?>"></div>
	</div>
</div>