<?php
if ( ! empty( $settings['btn_link']['url'] ) ) {
    $widget->add_render_attribute( 'button', 'href', $settings['btn_link']['url'] );

    if ( $settings['btn_link']['is_external'] ) {
        $widget->add_render_attribute( 'button', 'target', '_blank' );
    }

    if ( $settings['btn_link']['nofollow'] ) {
        $widget->add_render_attribute( 'button', 'rel', 'nofollow' );
    }
} ?>
<div class="pxl-meta-box pxl-meta-box1 <?php echo esc_attr($settings['style']); ?> <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms" data-wow-duration="<?php echo esc_attr($settings['pxl_animate_duration']); ?>s">
    <div class="pxl-item--inner">
        <<?php echo esc_attr($settings['title_tag']); ?> class="pxl-item--title el-empty"><?php echo pxl_print_html($settings['title']); ?></<?php echo esc_attr($settings['title_tag']); ?>>
        <a class="btn btn-default <?php if($settings['style'] == 'style2') { echo 'style-dark'; } ?>" <?php pxl_print_html($widget->get_render_attribute_string( 'button' )); ?>>
            <span class="pxl-btn--text pxl-wobble" data-animation="pxl-xspin">
                <?php if(!empty($settings['btn_text'])) {
                    $btn_text = $settings['btn_text'];
                } else {
                    $btn_text = pxl_print_html('Customer Application', 'agria');
                }
                $words = explode(' ', $btn_text);
                foreach ($words as $word) {
                    echo '<span>' . htmlspecialchars($word) . '</span> ';
                }
                ?>
            </span>
        </a>
    </div>
</div>