<?php
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$col_xxl = $widget->get_setting('col_xxl', '');
if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');
$arrows = $widget->get_setting('arrows','false');
$pagination = $widget->get_setting('pagination','false');
$pagination_type = $widget->get_setting('pagination_type','bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay', '');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite','false');
$speed = $widget->get_setting('speed', '500');
$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => '1',
    'slide_mode'                    => 'slide',
    'slides_to_show'                => $col_xl,
    'slides_to_show_xxl'             => $col_xxl,
    'slides_to_show_lg'             => $col_lg,
    'slides_to_show_md'             => $col_md,
    'slides_to_show_sm'             => $col_sm,
    'slides_to_show_xs'             => $col_xs,
    'slides_to_scroll'              => $slides_to_scroll,
    'arrow'                         => $arrows,
    'pagination'                    => $pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => $autoplay,
    'pause_on_hover'                => $pause_on_hover,
    'pause_on_interaction'          => 'true',
    'delay'                         => $autoplay_speed,
    'loop'                          => $infinite,
    'speed'                         => $speed
];
$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]);
$img_size = '';
if(!empty($settings['img_size'])) {
    $img_size = $settings['img_size'];
} else {
    $img_size = 'full';
}
if(isset($settings['list']) && !empty($settings['list']) && count($settings['list'])): ?>
    <div class="pxl-swiper-sliders pxl-meta-box-carousel pxl-meta-box-carousel1 pxl-parent-transition pxl-swiper-arrow-show" data-arrow="<?php echo esc_attr($arrows); ?>">
        <div class="pxl-carousel-inner">
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper">
                    <?php foreach ($settings['list'] as $key => $value):
                        $title = isset($value['title']) ? $value['title'] : '';
                        $image = isset($value['image']) ? $value['image'] : '';
                        $btn_text = isset($value['btn_text']) ? $value['btn_text'] : '';
                        $link = isset($value['link']) ? $value['link'] : '';
                        $link_key = $widget->get_repeater_setting_key( 'title', 'value', $key );
                        $social = isset($value['social']) ? $value['social'] : '';
                        if ( ! empty( $link['url'] ) ) {
                            $widget->add_render_attribute( $link_key, 'href', $link['url'] );

                            if ( $link['is_external'] ) {
                                $widget->add_render_attribute( $link_key, 'target', '_blank' );
                            }

                            if ( $link['nofollow'] ) {
                                $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                            }
                        }
                        $link_attributes = $widget->get_render_attribute_string( $link_key );
                        ?>
                        <div class="pxl-swiper-slide">
                            <div class="pxl-item--inner pxl-transtion <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms" data-wow-duration="<?php echo esc_attr($settings['pxl_animate_duration']); ?>s">
                                <?php if(!empty($title)) : ?>
                                    <h4 class="pxl-item--title el-empty">
                                        <a <?php echo implode( ' ', [ $link_attributes ] ); ?>><?php echo pxl_print_html($title); ?></a>
                                    </h4>
                                <?php endif; ?>
                                <?php if(!empty($social)) : ?>
                                    <div class="pxl-item--content">
                                        <?php $team_social = json_decode($social, true);
                                        foreach ($team_social as $value): ?>
                                            <?php if(! empty($value['url'])){ ?><a href="<?php echo esc_url($value['url']); ?>" ><?php } ?><span><?php echo pxl_print_html($value['content']); ?></span><?php if(! empty($value['url'])){ ?></a><?php } ?>
                                        <?php endforeach; ?>
                                    </div>
                                <?php endif; ?>
                                <?php if ( !empty($image['id']) ) :
                                    $img_icon  = pxl_get_image_by_size( array(
                                        'attach_id'  => $image['id'],
                                        'thumb_size' => $img_size,
                                    ) );
                                    $thumbnail_icon    = $img_icon['thumbnail']; ?>
                                    <div class="pxl-item--image"><?php echo pxl_print_html($thumbnail_icon); ?></div>
                                <?php endif; ?>
                                <?php if($settings['show_button'] == 'true' && !empty($link['url'])) : ?>
                                    <a class="btn-style2 pxl-transtion" <?php echo implode( ' ', [ $link_attributes ] ); ?>>
                                        <span>
                                            <?php if(!empty($btn_text)) {
                                                echo pxl_print_html($btn_text);
                                            } else {
                                                echo pxl_print_html('Learn more', 'agria');
                                            } ?>
                                        </span>
                                    </a>
                                <?php endif; ?>
                           </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        <?php if($arrows !== 'false' || $pagination !== 'false'): ?>
            <div class="wp-arrow">
                <?php if($arrows !== 'false'): ?>
                    <div class="pxl-swiper-arrow pxl-swiper-arrow-prev"><i class="icomoon icon-arrow-back-left- rtl-icon"></i></div>
                <?php endif; ?>
                    <?php if($pagination !== 'false'): ?>
                        <div class="pxl-swiper-dots"></div>
                    <?php endif; ?>
                <?php if($arrows !== 'false'): ?>
                    <div class="pxl-swiper-arrow pxl-swiper-arrow-next"><i class="icomoon icon-arrow-forward-ne1 rtl-icon"></i></div>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
<?php endif; ?>
