<?php
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');
$arrows = $widget->get_setting('arrows','false');
$pagination = $widget->get_setting('pagination','false');
$pagination_type = $widget->get_setting('pagination_type','bullets');

$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay', '');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite','false');
$speed = $widget->get_setting('speed', '500');
$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => '1',
    'slide_mode'                    => 'slide',
    'slides_to_show'                => 1,
    'slides_to_show_xxl'             => 1,
    'slides_to_show_lg'             => 1,
    'slides_to_show_md'             => 1,
    'slides_to_show_sm'             => 1,
    'slides_to_show_xs'             => 1,
    'slides_to_scroll'              => 1,
    'arrow'                         => $arrows,
    'pagination'                    => $pagination,
    'pagination_type'               => $pagination_type,

    'autoplay'                      => $autoplay,
    'pause_on_hover'                => $pause_on_hover,
    'pause_on_interaction'          => 'true',
    'delay'                         => $autoplay_speed,
    'loop'                          => $infinite,
    'speed'                         => $speed
];
$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]);
if(isset($settings['project']) && !empty($settings['project']) && count($settings['project'])): ?>
    <div class="pxl-swiper-sliders pxl-project-carousel pxl-project-carousel1" data-arrow="<?php echo esc_attr($arrows); ?>">

        <?php if(!empty($settings['title_text']) || !empty($settings['sub_title']) || ($arrows !== 'false') || ($pagination !== 'false') )  : ?>
            <div class="container-custom <?php echo esc_attr($settings['style_alignment']); ?>">
                <?php if(!empty($settings['title_text']) || !empty($settings['sub_title'])) : ?>
                    <div class="wp-title">
                        <?php if(!empty($settings['title_text'])) : ?>
                            <h3 class="el--title">
                                <?php echo pxl_print_html($settings['title_text']); ?>
                            </h3>
                        <?php endif; ?>
                        <?php if(!empty($settings['sub_title'])) : ?>
                            <div class="el--sub-title">
                                <?php echo pxl_print_html($settings['sub_title']); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
                <?php if($arrows !== 'false' || $pagination !== 'false'): ?>
                    <div class="wp-arrow">
                        <?php if($arrows !== 'false'): ?>
                            <div class="pxl-swiper-arrow pxl-swiper-arrow-prev"><i class="icomoon icon-arrow-back-left- rtl-icon"></i></div>
                        <?php endif; ?>
                            <?php if($pagination !== 'false'): ?>
                                <div class="pxl-swiper-dots"></div>
                            <?php endif; ?>
                        <?php if($arrows !== 'false'): ?>
                            <div class="pxl-swiper-arrow pxl-swiper-arrow-next"><i class="icomoon icon-arrow-forward-ne1 rtl-icon"></i></div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <div class="pxl-carousel-inner">
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper">
                    <?php foreach ($settings['project'] as $key => $value):
                        $feature = isset($value['feature']) ? $value['feature'] : '';
                        $img_size = isset($value['img_size']) ? $value['img_size'] : '';
                        $image_size = !empty($img_size) ? $img_size : '1170x638';
                        $title = isset($value['title']) ? $value['title'] : '';
                        $text1 = isset($value['text1']) ? $value['text1'] : '';
                        $text2 = isset($value['text2']) ? $value['text2'] : '';
                        $text3 = isset($value['text3']) ? $value['text3'] : '';
                        ?>
                        <div class="pxl-swiper-slide">
                            <div class="pxl-item--inner <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                                 <?php if(!empty($feature['id'])) {
                                    $img_feature = pxl_get_image_by_size( array(
                                        'attach_id'  => $feature['id'],
                                        'thumb_size' => $image_size,
                                        'class' => 'no-lazyload',
                                    ));
                                    $thumbnail_feature = $img_feature['thumbnail'];?>
                                    <div class="pxl-item--feature">
                                        <?php echo wp_kses_post($thumbnail_feature); ?>
                                    </div>
                                <?php } ?>
                                <div class="pxl-meta">
                                    <?php if(!empty($title)) { ?>
                                        <h4 class="pxl-item--title"><?php echo pxl_print_html($title); ?></h4>
                                    <?php } ?>
                                    <?php if(!empty($text1) || !empty($text2) || !empty($text3)) { ?>
                                        <ul>
                                            <?php if(!empty($text1)) { ?>
                                                <li><?php echo pxl_print_html($text1); ?></li>
                                            <?php } ?>
                                            <?php if(!empty($text2)) { ?>
                                                <li><?php echo pxl_print_html($text2); ?></li>
                                            <?php } ?>
                                            <?php if(!empty($text3)) { ?>
                                                <li><?php echo pxl_print_html($text3); ?></li>
                                            <?php } ?>
                                        </ul>
                                    <?php } ?>
                                </div>
                           </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
