<?php

add_action( 'pxl_post_metabox_register', 'agria_page_options_register' );
function agria_page_options_register( $metabox ) {

	$panels = [
		'post' => [
			'opt_name'            => 'post_option',
			'display_name'        => esc_html__( 'Post Settings', 'agria' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'Post Header', 'agria' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
				        agria_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
				],
				'post_title' => [
					'title'  => esc_html__( 'Post Title', 'agria' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
				        agria_post_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
				],
				'post_settings' => [
					'title'  => esc_html__( 'Post Settings', 'agria' ),
					'icon'   => 'el el-refresh',
					'fields' => array_merge(
						agria_sidebar_pos_opts(['prefix' => 'post_', 'default' => true, 'default_value' => '-1']),
						array(
					        array(
					            'id'       => 'post_title_on',
					            'title'    => esc_html__('Title', 'agria'),
					            'subtitle' => esc_html__('Show Title on single post.', 'agria'),
					            'type'     => 'switch',
					            'default'  => true
					        ),
						),
						array(
					        array(
					            'id'       => 'post_feature_image_on',
					            'title'    => esc_html__('Feature Image', 'agria'),
					            'subtitle' => esc_html__('Show feature image on single post.', 'agria'),
					            'type'     => 'switch',
					            'default'  => true,
					        ),
						),
						array(
							array(
								'id'           => 'align_content_post',
								'type'         => 'button_set',
								'title'        => esc_html__( 'Align Content', 'agria' ),
								'options'      => array(
									'content-left'  => esc_html__(' Left (Default)', 'agria'),
					                'content-center' => esc_html__('Center', 'agria'),
					                'content-right'  => esc_html__('Right', 'agria')
								),
								'default'      => 'content-left',
								'force_output' => true
							),
						),
						array(
					        array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Spacing Top/Bottom', 'agria' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							),
					    ),
					)
				],
			]
		],
		'page' => [
			'opt_name'            => 'pxl_page_options',
			'display_name'        => esc_html__( 'Page Settings', 'agria' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'Header', 'agria' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						array(
		                  	array(
		                        'id'       => 'disable_header',
		                        'title'    => esc_html__('Disable', 'agria'),
		                        'type'     => 'switch',
		                        'default'  => '0',
		                    ),
		              	),
				        agria_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
					        array(
				                'id'       => 'p_menu',
				                'type'     => 'select',
				                'title'    => esc_html__( 'Menu', 'agria' ),
				                'options'  => agria_get_nav_menu_slug(),
				                'default' => '-1',
				            ),
					    )
				    )

				],
				'header_mobile' => [
					'title'  => esc_html__( 'Header Mobile', 'agria' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						array(
					        array(
				                'id'       => 'pm_menu',
				                'type'     => 'select',
				                'title'    => esc_html__( 'Menu Mobile', 'agria' ),
				                'options'  => agria_get_nav_menu_slug(),
				                'default' => '-1',
				            ),
					    )
				    )
				],
				'page_title' => [
					'title'  => esc_html__( 'Page Title', 'agria' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
				        agria_page_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
				],
				'content' => [
					'title'  => esc_html__( 'Content', 'agria' ),
					'icon'   => 'el-icon-pencil',
					'fields' => array_merge(
						agria_sidebar_pos_opts(['prefix' => 'page_', 'default' => false, 'default_value' => '0']),
						array(
					        array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Spacing Top/Bottom', 'agria' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							),
							array(
					        	'id'           => 'loading_page',
					        	'type'         => 'button_set',
					        	'title'        => esc_html__( 'Loading', 'agria' ),
					        	'options'      => array(
					        		'-1'  => esc_html__( 'Inherit', 'agria' ),
					        		'bd' => esc_html__( 'Builder', 'agria' ),
					        	),
					        	'default'      => '-1',
					        ),
					        array(
					        	'id'    => 'loader_style',
					        	'type'  => 'select',
					        	'title' => esc_html__('Loader Style', 'agria'),
					        	'options' => [
					        		'style-flower'           => esc_html__('Flower Petal', 'agria'),
					        		'style-rotate'          => esc_html__('Flower Rotate', 'agria'),
					        	],
					        	'default' => 'style-flower',
					        	'indent' => true,
					        	'required' => array( 0 => 'loading_page', 1 => 'equals', 2 => 'bd' ),
					        ),
					    )
					)
				],
				'footer' => [
					'title'  => esc_html__( 'Footer', 'agria' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
						array(
		                  	array(
		                        'id'       => 'disable_footer',
		                        'title'    => esc_html__('Disable', 'agria'),
		                        'type'     => 'switch',
		                        'default'  => '0',
		                    ),
		              	),
				        agria_footer_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
				],
				'colors' => [
					'title'  => esc_html__( 'Colors', 'agria' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
				        array(
				        	array(
					            'id'          => 'primary_color',
					            'type'        => 'color',
					            'title'       => esc_html__('Primary Color', 'agria'),
					            'transparent' => false,
					            'default'     => ''
					        ),
					    )
				    )
				]
			]
		],
		'portfolio' => [
			'opt_name'            => 'pxl_portfolio_options',
			'display_name'        => esc_html__( 'Portfolio Options', 'agria' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'portfolio_header' => [
					'title'  => esc_html__( 'General', 'agria' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
				        agria_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
				        agria_post_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
					        array(
					            'id'=> 'portfolio_video_link',
					            'type' => 'text',
					            'title' => esc_html__('Video Link', 'agria'),
					            'validate' => 'url',
					            'default' => '',
					        ),
					        array(
					            'id'       => 'portfolio_icon_font',
					            'type'     => 'pxl_iconpicker',
					            'title'    => esc_html__('Icon Font', 'agria'),
					        ),
						)
				    )
				],
				'portfolio_content' => [
					'title'  => esc_html__( 'Content', 'agria' ),
					'icon'   => 'el-icon-pencil',
					'fields' => array_merge(
						agria_sidebar_pos_opts(['prefix' => 'portfolio_', 'default' => false, 'default_value' => '0']),
						array(
					        array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Spacing Top/Bottom', 'agria' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							),
					    )
					)
				],
				'portfolio_footer' => [
					'title'  => esc_html__( 'Footer', 'agria' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
				        agria_footer_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
				],
			]
		],
		'service' => [
			'opt_name'            => 'pxl_service_options',
			'display_name'        => esc_html__( 'Service Settings', 'agria' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'General', 'agria' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						array(
							array(
					            'id'=> 'service_external_link',
					            'type' => 'text',
					            'title' => esc_html__('External Link', 'agria'),
					            'validate' => 'url',
					            'default' => '',
					        ),
							array(
					            'id'=> 'service_excerpt',
					            'type' => 'textarea',
					            'title' => esc_html__('Excerpt', 'agria'),
					            'validate' => 'html_custom',
					            'default' => '',
					        ),
					        array(
					            'id'=> 'service_specification',
					            'type' => 'multi_text',
					            'title' => esc_html__('Content List', 'agria'),
					            'validate' => 'html_custom',
					            'default' => '',
					        ),
					        array(
					            'id'       => 'service_icon_type',
					            'type'     => 'button_set',
					            'title'    => esc_html__('Icon Type', 'agria'),
					            'options'  => array(
					                'icon'  => esc_html__('Icon', 'agria'),
					                'image'  => esc_html__('Image', 'agria'),
					            ),
					            'default'  => 'icon'
					        ),
					        array(
					            'id'       => 'service_icon_font',
					            'type'     => 'pxl_iconpicker',
					            'title'    => esc_html__('Icon', 'agria'),
					            'required' => array( 0 => 'service_icon_type', 1 => 'equals', 2 => 'icon' ),
            					'force_output' => true
					        ),
					        array(
					            'id'       => 'service_icon_img',
					            'type'     => 'media',
					            'title'    => esc_html__('Icon Image', 'agria'),
					            'default' => '',
					            'required' => array( 0 => 'service_icon_type', 1 => 'equals', 2 => 'image' ),
				            	'force_output' => true
					        ),
					        array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'padding',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Content Spacing Top/Bottom', 'agria' ),
								'default'        => array(
									'padding-top'    => '',
									'padding-bottom' => '',
									'units'          => 'px',
								)
							),
						)
				    )
				],
				'header_service' => [
					'title'  => esc_html__( 'Header', 'agria' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						array(
		                  	array(
		                        'id'       => 'disable_header',
		                        'title'    => esc_html__('Disable', 'agria'),
		                        'type'     => 'switch',
		                        'default'  => '0',
		                    ),
		              	),
				        agria_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
					        array(
				                'id'       => 'p_menu',
				                'type'     => 'select',
				                'title'    => esc_html__( 'Menu', 'agria' ),
				                'options'  => agria_get_nav_menu_slug(),
				                'default' => '',
				            ),
					    )
				    )

				],
				'page_title' => [
					'title'  => esc_html__( 'Page Title', 'agria' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
				        agria_page_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
				],
			]
		],
		'product' => [
			'opt_name'            => 'pxl_product_options',
			'display_name'        => esc_html__( 'Product Settings', 'agria' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'General', 'agria' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						array(
							array(
					            'id'=> 'unit_price',
					            'type' => 'text',
					            'title' => esc_html__('Unit Price', 'agria'),
					            'subtitle' => esc_html__('Product price by weight.', 'agria'),
					            'validate' => 'html_custom',
					            'default' => '',
					        ),
							array(
								'id'       => 'badge_new',
								'title'    => esc_html__('Show New Badge', 'agria'),
								'subtitle' => esc_html__('Show a new badge for item.', 'agria'),
								'type'     => 'switch',
								'default'  => '0',
							),
							array(
								'id'    => 'product_page_style',
								'type'  => 'select',
								'title' => esc_html__('Product Page Style', 'agria'),
								'options' => [
									'style1'       	   => esc_html__('Style 1', 'agria'),
									'style2'       	   => esc_html__('Style 2', 'agria'),
								],
								'default' => 'style1',
							),
						)
				    )
				],
				'product_info' => [
					'title'  => esc_html__( 'Product Info', 'agria' ),
					'icon'   => 'el el-shopping-cart',
					'fields' => array_merge(
						array(
							array(
								'id'=> 'product_tab_title',
								'type' => 'text',
								'title' => esc_html__('Tab Title', 'agria'),
								'placeholder' => esc_html__('Product Details', 'agria' ),
								'validate' => 'html_custom',
								'default' => '',
							),
							array(
								'id'       => 'feature_tab_on',
								'title'    => esc_html__('Show Additional Information Tab', 'agria'),
								'subtitle' => esc_html__('Show a additional information tab on the product page.', 'agria'),
								'type'     => 'switch',
								'default'  => '0',
							),
							array(
								'id'=> 'product_specification_title',
								'type' => 'text',
								'title' => esc_html__('Additional Tab Title', 'agria'),
								'placeholder' => esc_html__('Vendor Info', 'agria' ),
								'validate' => 'html_custom',
								'default' => '',
								'required' => array( 0 => 'feature_tab_on', 1 => 'equals', 2 => '1' ),
							),
							array(
								'id'=> 'product_specification_content',
								'type' => 'textarea',
								'title' => esc_html__('Tab Content', 'agria'),
								'validate' => 'html_custom',
								'default' => '',
								'required' => array( 0 => 'feature_tab_on', 1 => 'equals', 2 => '1' ),
							),
							array(
								'id'=> 'product_specification',
								'type' => 'multi_text',
								'title' => esc_html__('Tab Content List', 'agria'),
								'validate' => 'html_custom',
								'default' => '',
								'required' => array( 0 => 'feature_tab_on', 1 => 'equals', 2 => '1' ),
							),
							array(
					            'id'=> 'product_info_1',
					            'type' => 'text',
					            'title' => esc_html__('Product Info Delivery 1', 'agria'),
					            'validate' => 'html_custom',
					            'default' => '',
					        ),
					        array(
					            'id'=> 'product_info_2',
					            'type' => 'text',
					            'title' => esc_html__('Product Info Delivery 2', 'agria'),
					            'validate' => 'html_custom',
					            'default' => '',
					        ),
					        array(
					            'id'=> 'product_info_3',
					            'type' => 'text',
					            'title' => esc_html__('Product Info Delivery 3', 'agria'),
					            'validate' => 'html_custom',
					            'default' => '',
					        ),
					        array(
					            'id'=> 'product_info_4',
					            'type' => 'text',
					            'title' => esc_html__('Product Info Delivery 4', 'agria'),
					            'validate' => 'html_custom',
					            'default' => '',
					        ),
						)
				    )
				],
				'header_product' => [
					'title'  => esc_html__( 'Header', 'agria' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						array(
		                  	array(
		                        'id'       => 'disable_header',
		                        'title'    => esc_html__('Disable', 'agria'),
		                        'type'     => 'switch',
		                        'default'  => '0',
		                    ),
		              	),
				        agria_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
					        array(
				                'id'       => 'p_menu',
				                'type'     => 'select',
				                'title'    => esc_html__( 'Menu', 'agria' ),
				                'options'  => agria_get_nav_menu_slug(),
				                'default' => '',
				            ),
					    )
				    )

				],
				'page_title' => [
					'title'  => esc_html__( 'Page Title', 'agria' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
						agria_page_title_shop_opts([
							'default'         => true,
							'default_value'   => 'df'
						])
					)
				],
			]
		],
		'pxl-template' => [ //post_type
			'opt_name'            => 'pxl_hidden_template_options',
			'display_name'        => esc_html__( 'Template Settings', 'agria' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'General', 'agria' ),
					'icon'   => 'el-icon-website',
					'fields' => array(
						array(
							'id'    => 'template_type',
							'type'  => 'select',
							'title' => esc_html__('Type', 'agria'),
				            'options' => [
				            	'df'       	   => esc_html__('Select Type', 'agria'),
								'header'       => esc_html__('Header', 'agria'),
								'footer'       => esc_html__('Footer', 'agria'),
								'mega-menu'    => esc_html__('Mega Menu', 'agria'),
								'page-title'   => esc_html__('Page Title', 'agria'),
								'tab' => esc_html__('Tab', 'agria'),
								'hidden-panel' => esc_html__('Hidden Panel', 'agria'),
								'widget' => esc_html__('Widget Sidebar', 'agria'),
								'shop' => esc_html__('Shop', 'agria'),
				            ],
				            'default' => 'df',
				        ),
				        array(
							'id'    => 'header_type',
							'type'  => 'button_set',
							'title' => esc_html__('Header Type', 'agria'),
				            'options' => [
				            	'px-header--default'       	   => esc_html__('Default', 'agria'),
								'px-header--transparent'       => esc_html__('Transparent', 'agria'),
				            ],
				            'default' => 'px-header--default',
				            'indent' => true,
                			'required' => array( 0 => 'template_type', 1 => 'equals', 2 => 'header' ),
				        ),
				        array(
							'id'       => 'template_position',
							'type'     => 'select',
							'title'    => esc_html__('Display Position', 'agria'),
							'options'  => [
								'left'   => esc_html__('Left Position', 'agria'),
								'top'    => esc_html__('Top Position', 'agria'),
								'center' => esc_html__('Center Position (popup)', 'agria'),
								'right'  => esc_html__('Right Position', 'agria'),
								'full'   => esc_html__('Full Screen', 'agria'),
				            ],
							'default'  => 'left',
							'required' => [ 'template_type', '=', 'hidden-panel']
				        ),
					),

				],
			]
		],
	];

	$metabox->add_meta_data( $panels );
}
