<?php

class PxlIconCart_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_icon_cart';
    protected $title = 'Shop Cart Pxl';
    protected $icon = 'eicon-cart-medium';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"section_content","label":"Source Settings","tab":"content","controls":[{"name":"pxl_icon","label":"Icon","type":"icons","fa4compatibility":"icon"},{"name":"btn_text","label":"Button Text","type":"text","label_block":true,"placeholder":"Cart"},{"name":"value_text","label":"Value Text","type":"text","label_block":true,"placeholder":"Item"},{"name":"align","label":"Alignment","type":"choose","control_type":"responsive","options":{"left":{"title":"Left","icon":"fa fa-align-left"},"center":{"title":"Center","icon":"fa fa-align-center"},"right":{"title":"Right","icon":"fa fa-align-right"},"justify":{"title":"Justified","icon":"fa fa-align-justify"}},"prefix_class":"elementor-align-","default":"","selectors":{"{{WRAPPER}} .pxl-cart-sidebar-button":"text-align: {{VALUE}}"}}]},{"name":"section_style","label":"Content","tab":"style","controls":[{"name":"icon_font_size","label":"Icon Font Size","type":"slider","control_type":"responsive","size_units":["px","%","vw","vh"],"range":{"px":{"min":0,"max":1000,"step":1},"%":{"min":0,"max":200},"vw":{"min":0,"max":200},"vh":{"min":0,"max":200}},"selectors":{"{{WRAPPER}} .pxl-cart-sidebar-button i":"font-size: {{SIZE}}{{UNIT}};"},"separator":"after"},{"name":"text_typography","label":"Text Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-cart-text"},{"name":"text_margin","label":"Text Margin (px)","type":"dimensions","control_type":"responsive","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-cart-text":"margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"separator":"after"},{"name":"value_typography","label":"Value Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-cart-counters"},{"name":"value_margin","label":"Value Margin (px)","type":"dimensions","control_type":"responsive","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-cart-counters":"margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"separator":"after"},{"name":"btn_height","label":"Button Height (px)","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-cart-sidebar-button":"line-height: {{SIZE}}{{UNIT}};"}},{"name":"btn_border_radius","label":"Border Radius","type":"dimensions","control_type":"responsive","size_units":["px","%"],"default":{"unit":"%"},"range":{"%":{"min":0,"max":100}},"selectors":{"{{WRAPPER}} .pxl-cart-sidebar-button":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"btn_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-cart-sidebar-button"},{"name":"btn_padding","label":"Padding","type":"dimensions","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-cart-sidebar-button":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"control_type":"responsive"},{"name":"color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-cart-sidebar-button, .dark-mode {{WRAPPER}} .pxl-cart-sidebar-button i":"color: {{VALUE}};"}},{"name":"btn_bg_color","label":"Background Color","type":"color","selectors":{"{{WRAPPER}} .pxl-cart-sidebar-button":"background-color: {{VALUE}};"}},{"name":"border_color","label":"Border Color","type":"color","selectors":{"{{WRAPPER}} .pxl-cart-sidebar-button:before":"border-color: {{VALUE}};","{{WRAPPER}} .pxl-cart-sidebar-button .top-bottom:before, {{WRAPPER}} .pxl-cart-sidebar-button .top-bottom:after, {{WRAPPER}} .pxl-cart-sidebar-button .left-right:before, {{WRAPPER}} .pxl-cart-sidebar-button .left-right:after":"background-color: {{VALUE}};"}},{"name":"darkmode_color","label":"Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-cart-sidebar-button, .dark-mode {{WRAPPER}} .pxl-cart-sidebar-button i":"color: {{VALUE}};"},"separator":"before"},{"name":"darkmode_btn_bg_color","label":"Background Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-cart-sidebar-button":"background-color: {{VALUE}};"}},{"name":"darkmode_border_color","label":"Border Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-cart-sidebar-button:before":"border-color: {{VALUE}};",".dark-mode {{WRAPPER}} .pxl-cart-sidebar-button .top-bottom:before, .dark-mode {{WRAPPER}} .pxl-cart-sidebar-button .top-bottom:after, .dark-mode {{WRAPPER}} .pxl-cart-sidebar-button .left-right:before, .dark-mode {{WRAPPER}} .pxl-cart-sidebar-button .left-right:after":"background-color: {{VALUE}};"}}]}]}';
    protected $styles = array(  );
    protected $scripts = array(  );
}