<?php

class PxlPostGrid_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_post_grid';
    protected $title = 'Post Grid Pxl';
    protected $icon = 'eicon-posts-grid';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"tab_layout","label":"Layout","tab":"layout","controls":[{"name":"post_type","label":"Select Post Type","type":"select","multiple":true,"options":{"post":"Post","portfolio":"Portfolio","service":"Service"},"default":"post"},{"name":"layout_post","label":"Select Templates of Post","type":"layoutcontrol","default":"post-1","options":{"post-1":{"label":"Layout 1","image":"https:\/\/glansadesigns.com\/testing\/risenew\/wp-content\/themes\/agria\/elements\/templates\/pxl_post_grid\/img-layout\/post-layout1.jpg"}},"prefix_class":"pxl-post-layout-","condition":{"post_type":["post"]}},{"name":"layout_portfolio","label":"Select Templates of Portfolio","type":"layoutcontrol","default":"post-1","options":{"portfolio-1":{"label":"Layout 1","image":"https:\/\/glansadesigns.com\/testing\/risenew\/wp-content\/themes\/agria\/elements\/templates\/pxl_post_grid\/img-layout\/portfolio-layout1.jpg"}},"prefix_class":"pxl-post-layout-","condition":{"post_type":["portfolio"]}},{"name":"layout_service","label":"Select Templates of Service","type":"layoutcontrol","default":"post-1","options":{"service-1":{"label":"Layout 1","image":"https:\/\/glansadesigns.com\/testing\/risenew\/wp-content\/themes\/agria\/elements\/templates\/pxl_post_grid\/img-layout\/service-layout1.jpg"},"service-2":{"label":"Layout 2","image":"https:\/\/glansadesigns.com\/testing\/risenew\/wp-content\/themes\/agria\/elements\/templates\/pxl_post_grid\/img-layout\/service-layout2.jpg"}},"prefix_class":"pxl-post-layout-","condition":{"post_type":["service"]}}]},{"name":"tab_source","label":"Source","tab":"settings","controls":[{"name":"select_post_by","label":"Select posts by","type":"select","multiple":true,"options":{"term_selected":"Terms selected","post_selected":"Posts selected "},"default":"term_selected"},{"name":"source_post","label":"Select Term of Post","type":"select2","multiple":true,"options":{"agriculture|category":"Agriculture","climate|category":"Climate","food-facts|category":"Food Facts","food-waste|category":"Food Waste","stories|category":"Stories"},"condition":{"post_type":["post"],"select_post_by":"term_selected"}},{"name":"source_portfolio","label":"Select Term of Portfolio","type":"select2","multiple":true,"options":[],"condition":{"post_type":["portfolio"],"select_post_by":"term_selected"}},{"name":"source_service","label":"Select Term of Service","type":"select2","multiple":true,"options":{"service-list-01|service-category":"Service List - 01","service-list-02|service-category":"Service List - 02","service-list-home-06|service-category":"Service List \u2013 Home 06"},"condition":{"post_type":["service"],"select_post_by":"term_selected"}},{"name":"source_post_post_ids","label":"Select posts","type":"select2","multiple":true,"options":{"1113":"Original Spring Mix Packed New Salad","1111":"Earth Is What We All Have in Common","1116":"The Super Soil Organic Farming Strong plants","1121":"Grow Something Green! Plants in Plant-Based!","1124":"Growth and Challenges for Organic Farmers","1127":"The Big Flavor of Organic Produce Superior","1131":"Developing a More Inclusive Food Future","1135":"Wasting Water Unveiling Food\u2019s Water Footprint","1138":"Top 5 Drivers for The Dietary Supplement","1158":"Agriculture and Anti-Microbial Resistance","1161":"Organic Farming Fights Climate Change","1141":"6 Soil Carbon Schemes for Farmers to Consider","1144":"Problems Require Systemic Solutions","1147":"Helping the World Adapt to the Climate Crisis","1152":"Actions to Transform the Global Food","1154":"Women Farmers Making it Happen #IWD2023","4353":"How Calcium Deficiency Cause Osteoporosis?","4357":"Supporting Farmers Returning Agriculture","6325":"New Planter Performance Current Machine","6329":"Create Concept Agron Made Recycled Parts","6331":"Supporting Farmers Returning to Agriculture"},"condition":{"post_type":["post"],"select_post_by":"post_selected"}},{"name":"source_portfolio_post_ids","label":"Select posts","type":"select2","multiple":true,"options":{"3871":"Farm Innovations 1","3880":"Farm Innovations 2","3882":"Farm Innovations 3","3884":"Farm Innovations 4","3886":"Farm Innovations 5"},"condition":{"post_type":["portfolio"],"select_post_by":"post_selected"}},{"name":"source_service_post_ids","label":"Select posts","type":"select2","multiple":true,"options":{"1658":"Animal Nutrition","1660":"Food Beverage","1662":"Farm Services","1664":"Agriculture","5971":"Irigation System","5977":"Tractors Equipment","5979":"Harvesting Equipment","5981":"Seeding Equipment","5983":"Planting Equipment","6071":"Irigation System","6074":"Tractors Equipment","6076":"Harvesting Equipment","6078":"Seeding Equipment","6080":"Planting Equipment","7652":"Excellent Cow Care Service","7656":"Semper feugiat nibh sed pulvinar"},"condition":{"post_type":["service"],"select_post_by":"post_selected"}},{"name":"orderby","label":"Order By","type":"select","default":"date","options":{"date":"Date","ID":"ID","author":"Author","title":"Title","rand":"Random"}},{"name":"order","label":"Sort Order","type":"select","default":"desc","options":{"desc":"Descending","asc":"Ascending"}},{"name":"limit","label":"Total items","type":"number","default":"6"}]},{"name":"tab_grid","label":"Grid","tab":"settings","controls":[{"name":"img_size","label":"Image Size","type":"text","description":"Enter image size (Example: \"thumbnail\", \"medium\", \"large\", \"full\" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height))."},{"name":"pxl_animate","label":"Case Animate","type":"select","options":{"":"None","wow bounce":"bounce","wow flash":"flash","wow pulse":"pulse","wow rubberBand":"rubberBand","wow shake":"shake","wow swing":"swing","wow tada":"tada","wow wobble":"wobble","wow bounceIn":"bounceIn","wow bounceInDown":"bounceInDown","wow bounceInLeft":"bounceInLeft","wow bounceInRight":"bounceInRight","wow bounceInUp":"bounceInUp","wow bounceOut":"bounceOut","wow bounceOutDown":"bounceOutDown","wow bounceOutLeft":"bounceOutLeft","wow bounceOutRight":"bounceOutRight","wow bounceOutUp":"bounceOutUp","wow fadeIn":"fadeIn","wow fadeInDown":"fadeInDown","wow fadeInDownBig":"fadeInDownBig","wow fadeInLeft":"fadeInLeft","wow fadeInLeftBig":"fadeInLeftBig","wow fadeInRight":"fadeInRight","wow fadeInRightBig":"fadeInRightBig","wow fadeInUp":"fadeInUp","wow fadeInUpBig":"fadeInUpBig","wow fadeOut":"fadeOut","wow fadeOutDown":"fadeOutDown","wow fadeOutDownBig":"fadeOutDownBig","wow fadeOutLeft":"fadeOutLeft","wow fadeOutLeftBig":"fadeOutLeftBig","wow fadeOutRight":"fadeOutRight","wow fadeOutRightBig":"fadeOutRightBig","wow fadeOutUp":"fadeOutUp","wow fadeOutUpBig":"fadeOutUpBig","wow flip":"flip","wow flipInX":"flipInX","wow flipInY":"flipInY","wow flipOutX":"flipOutX","wow flipOutY":"flipOutY","wow lightSpeedIn":"lightSpeedIn","wow lightSpeedOut":"lightSpeedOut","wow rotateIn":"rotateIn","wow rotateInDownLeft":"rotateInDownLeft","wow rotateInDownRight":"rotateInDownRight","wow rotateInUpLeft":"rotateInUpLeft","wow rotateInUpRight":"rotateInUpRight","wow rotateOut":"rotateOut","wow rotateOutDownLeft":"rotateOutDownLeft","wow rotateOutDownRight":"rotateOutDownRight","wow rotateOutUpLeft":"rotateOutUpLeft","wow rotateOutUpRight":"rotateOutUpRight","wow hinge":"hinge","wow rollIn":"rollIn","wow rollOut":"rollOut","wow zoomIn":"zoomIn","wow zoomInDown":"zoomInDown","wow zoomInLeft":"zoomInLeft","wow zoomInRight":"zoomInRight","wow zoomInUp":"zoomInUp","wow zoomOut":"zoomOut","wow zoomOutDown":"zoomOutDown","wow zoomOutLeft":"zoomOutLeft","wow zoomOutRight":"zoomOutRight","wow zoomOutUp":"zoomOutUp"},"default":""},{"name":"filter","label":"Filter on Masonry","type":"select","default":"false","options":{"true":"Enable","false":"Disable"},"condition":{"select_post_by":"term_selected"}},{"name":"filter_default_title","label":"Filter Default Title","type":"text","default":"Show All","condition":{"filter":"true","select_post_by":"term_selected"}},{"name":"filter_alignment","label":"Filter Alignment","type":"choose","control_type":"responsive","options":{"left":{"title":"Left","icon":"eicon-text-align-left"},"center":{"title":"Center","icon":"eicon-text-align-center"},"right":{"title":"Right","icon":"eicon-text-align-right"}},"selectors":{"{{WRAPPER}} .pxl-grid .pxl-grid-filter":"justify-content: {{VALUE}};"},"condition":{"filter":"true","select_post_by":"term_selected"}},{"name":"filter_margin1","label":"Filter Margin (px)","type":"dimensions","control_type":"responsive","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-grid .pxl-grid-filter":"margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"condition":{"filter":"true","select_post_by":"term_selected"}},{"name":"filter_margin","label":"Filter Item Margin","type":"dimensions","size_units":["px","%"],"default":{"unit":"%"},"range":{"%":{"min":0,"max":100},"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-grid .pxl-grid-filter .filter-item":"margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"control_type":"responsive","condition":{"filter":"true","select_post_by":"term_selected"}},{"name":"show_cursor_text","label":"Show Cursor Drag","type":"switcher","default":"false","conditions":{"relation":"or","terms":[{"terms":[{"name":"filter","operator":"==","value":"true"},{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1"]}]}]}},{"name":"cursor_text","label":"Cursor Text","type":"text","placeholder":"\u25c4 \u25ba","conditions":{"relation":"or","terms":[{"terms":[{"name":"filter","operator":"==","value":"true"},{"name":"show_cursor_text","operator":"==","value":"true"},{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1"]}]}]}},{"name":"pagination_type","label":"Pagination Type","type":"select","default":"false","options":{"pagination":"Pagination","loadmore":"Loadmore","false":"Disable"}},{"name":"pagination_style","label":"Pagination Style","type":"select","default":"pxl-pagination-style1","options":{"pxl-pagination-style1":"Style 1"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"pagination_type","operator":"==","value":"pagination"}]}]}},{"name":"pagination_color","label":"Pagination Color","type":"color","selectors":{"{{WRAPPER}} .pxl-pagination-wrap .pxl-pagination-links .page-numbers":"color: {{VALUE}};"},"condition":{"pagination_type":"pagination"}},{"name":"darkmode_pagination_color","label":"Pagination Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-pagination-wrap .pxl-pagination-links .page-numbers":"color: {{VALUE}};"},"condition":{"pagination_type":"pagination"}},{"name":"pagination_border_color","label":"Pagination Border Color","type":"color","selectors":{"{{WRAPPER}} .pxl-pagination-wrap .pxl-pagination-links .page-numbers":"border-color: {{VALUE}};"},"condition":{"pagination_type":"pagination"}},{"name":"darkmode_pagination_border_color","label":"Pagination Border Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-pagination-wrap .pxl-pagination-links .page-numbers":"border-color: {{VALUE}};"},"condition":{"pagination_type":"pagination"}},{"name":"pagination_active_color","label":"Pagination Active Color","type":"color","selectors":{"{{WRAPPER}} .pxl-pagination-wrap .pxl-pagination-links .page-numbers.current, {{WRAPPER}} .pxl-pagination-wrap .pxl-pagination-links .page-numbers:hover":"color: {{VALUE}}; border-color: {{VALUE}};"},"condition":{"pagination_type":"pagination"}},{"name":"darkmode_pagination_active_color","label":"Pagination Active Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-pagination-wrap .pxl-pagination-links .page-numbers.current, {{WRAPPER}} .pxl-pagination-wrap .pxl-pagination-links .page-numbers:hover":"color: {{VALUE}}; border-color: {{VALUE}};"},"condition":{"pagination_type":"pagination"}},{"name":"pagination_margin","label":"Pagination Margin","type":"dimensions","control_type":"responsive","size_units":["px","%","vw","vh"],"default":{"unit":"px"},"selectors":{"{{WRAPPER}} .pxl-pagination-links, {{WRAPPER}} .pxl-load-more":"margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"condition":{"pagination_type!":"false"}},{"name":"loadmore_style","label":"Loadmore Style","type":"select","default":"pxl-loadmore-style1","options":{"pxl-loadmore-style1":"Style 1","pxl-loadmore-style2":"Style 2"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"portfolio"},{"name":"pagination_type","operator":"==","value":"loadmore"}]}]}},{"name":"color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-button .btn":"color: {{VALUE}};"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"portfolio"},{"name":"pagination_type","operator":"==","value":"loadmore"}]}]}},{"name":"item_padding","label":"Item Padding","type":"dimensions","size_units":["px"],"default":{"top":"15","right":"15","bottom":"15","left":"15"},"selectors":{"{{WRAPPER}} .pxl-grid-inner":"margin-top: -{{TOP}}{{UNIT}}; margin-right: -{{RIGHT}}{{UNIT}}; margin-bottom: -{{BOTTOM}}{{UNIT}}; margin-left: -{{LEFT}}{{UNIT}};","{{WRAPPER}} .pxl-grid-inner .pxl-grid-item":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"control_type":"responsive"},{"name":"gap_extra","label":"Item Gap Bottom","description":"Add extra space at bottom of each items","type":"number","default":0,"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-grid-inner .pxl-grid-item":"margin-bottom: {{VALUE}}px;"}},{"name":"layout_mode","label":"Layout Mode","type":"select","default":"masonry","options":{"fitRows":"Fit Rows","masonry":"Masonry"}},{"name":"col_xs","label":"Columns XS Devices","type":"select","default":"1","options":{"1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"col_sm","label":"Columns SM Devices","type":"select","default":"2","options":{"1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"col_md","label":"Columns MD Devices","type":"select","default":"3","options":{"1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"col_lg","label":"Columns LG Devices","type":"select","default":"4","options":{"1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"col_xl","label":"Columns XL Devices","type":"select","default":"4","options":{"1":"1","2":"2","3":"3","4":"4","5":"5","6":"6"}},{"name":"grid_masonry","label":"Grid Masonry","type":"repeater","controls":[{"name":"col_xs_m","label":"Columns XS Devices","type":"select","default":"1","options":{"1":"1","2":"2","3":"3","4":"4","5":"5","6":"6","7":"7","8":"8","12":"12"}},{"name":"col_sm_m","label":"Columns SM Devices","type":"select","default":"2","options":{"1":"1","2":"2","3":"3","4":"4","5":"5","6":"6","7":"7","8":"8","12":"12"}},{"name":"col_md_m","label":"Columns MD Devices","type":"select","default":"3","options":{"1":"1","2":"2","3":"3","4":"4","5":"5","6":"6","7":"7","8":"8","12":"12"}},{"name":"col_lg_m","label":"Columns LG Devices","type":"select","default":"4","options":{"1":"1","2":"2","3":"3","4":"4","5":"5","6":"6","7":"7","8":"8","12":"12"}},{"name":"col_xl_m","label":"Columns XL Devices","type":"select","default":"4","options":{"1":"1","2":"2","3":"3","4":"4","5":"5","6":"6","7":"7","8":"8","12":"12"}},{"name":"img_size_m","label":"Image Size","type":"text","description":"Enter image size (Example: &quot;thumbnail&quot;, &quot;medium&quot;, &quot;large&quot;, &quot;full&quot; or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height))."}]}]},{"name":"tab_display","label":"Display","tab":"settings","controls":[{"name":"show_category","label":"Show Category","type":"switcher","default":"true","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1"]}]},{"terms":[{"name":"post_type","operator":"==","value":"portfolio"},{"name":"layout_portfolio","operator":"in","value":["portfolio-1"]}]}]}},{"name":"show_date","label":"Show Date","type":"switcher","default":"true","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1","post-2"]}]}]}},{"name":"show_excerpt","label":"Show Excerpt","type":"switcher","default":"true","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1"]}]},{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1","service-2"]}]}]}},{"name":"num_words","label":"Number of Words","type":"number","default":25,"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1"]},{"name":"show_excerpt","operator":"==","value":"true"}]},{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1","service-2"]},{"name":"show_excerpt","operator":"==","value":"true"}]}]}},{"name":"text_line","label":"Text Excerpt Line","type":"number","separator":"after","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1"]},{"name":"show_excerpt","operator":"==","value":"true"}]},{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1","service-2"]},{"name":"show_excerpt","operator":"==","value":"true"}]}]}},{"name":"show_button","label":"Show Button Readmore","type":"switcher","default":"true","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1","post-2"]}]},{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1","service-2"]}]}]}},{"name":"button_text","label":"Button Text","type":"text","placeholder":"Read More","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1","post-2"]},{"name":"show_button","operator":"==","value":"true"}]},{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1","service-2"]},{"name":"show_button","operator":"==","value":"true"}]}]}}]},{"name":"tab_style_general","label":"General","tab":"style","controls":[{"name":"post_box_align","label":"Box Alignment","type":"choose","control_type":"responsive","default":"left","options":{"left":{"title":"Left","icon":"eicon-text-align-left"},"center":{"title":"Center","icon":"eicon-text-align-center"},"right":{"title":"Right","icon":"eicon-text-align-right"}},"selectors":{"{{WRAPPER}} .pxl-grid-inner .pxl-item--inner ":"text-align: {{VALUE}};"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1"]}]},{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1","service-2"]}]}]}},{"name":"box_padding","label":"Item Padding","type":"dimensions","size_units":["px","%"],"default":{"unit":"%"},"selectors":{"{{WRAPPER}} .pxl-grid-inner .pxl-item--holder":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"control_type":"responsive","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1","service-2"]}]}]}},{"name":"style","label":"Style","type":"select","options":{"style1":"Style 1","style2":"Style 2","style3":"Style 3"},"default":"style1","condition":{"post_type":["post"],"layout_post":["post-1"]}}]},{"name":"tab_style_title","label":"Content","tab":"style","controls":[{"name":"img_margin","label":"Image Margin (px)","type":"dimensions","control_type":"responsive","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-grid .item--featured":"margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"condition":{"post_type":["post"],"layout_post":["post-1"]}},{"name":"border_color","label":"Border Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-item--holder":"border-color: {{VALUE}};"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1","service-2"]}]}]}},{"name":"darkmode_border_color","label":"Border Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-grid .pxl-item--holder":"border-color: {{VALUE}};"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1","service-2"]}]}]}},{"name":"icon_font_size1","label":"Icon Font Size (px)","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-grid .pxl-item--icon i":"font-size: {{SIZE}}{{UNIT}};"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1"]}]}]}},{"name":"icon_font_size2","label":"Icon Font Size (px)","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-item--holder .pxl-item--icon":"font-size: {{SIZE}}{{UNIT}};"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-2"]}]}]}},{"name":"icon_margin","label":"Icon Margin (px)","type":"dimensions","control_type":"responsive","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-grid .pxl-item--icon":"margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1","service-2"]}]}]}},{"name":"post_icon_color1","label":"Icon Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-item--icon i":"background-color: {{VALUE}}; background-image: unset;"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1"]}]}]}},{"name":"darkmode_post_icon_color1","label":"Icon Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-grid .pxl-item--icon i":"background-color: {{VALUE}}; background-image: unset;"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1"]}]}]}},{"name":"post_icon_color2","label":"Icon Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-item--icon":"background-color: {{VALUE}}; background-image: unset;"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-2"]}]}]}},{"name":"darkmode_post_icon_color2","label":"Icon Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-grid .pxl-item--icon":"background-color: {{VALUE}}; background-image: unset;"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-2"]}]}]}},{"name":"post_list_color","label":"List Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-item--inner .item--meta li":"color: {{VALUE}};","{{WRAPPER}} .pxl-grid .pxl-item--inner .item--meta li + li:before":"background-color: {{VALUE}};"},"condition":{"post_type":["post"],"layout_post":["post-1"]}},{"name":"darkmode_post_list_color","label":"List Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-grid .pxl-item--inner .item--meta li":"color: {{VALUE}};",".dark-mode {{WRAPPER}} .pxl-grid .pxl-item--inner .item--meta li + li:before":"background-color: {{VALUE}};"},"condition":{"post_type":["post"],"layout_post":["post-1"]}},{"name":"post_list_link_color","label":"List Link Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-item--inner .item--meta li a":"color: {{VALUE}};"},"condition":{"post_type":["post"],"layout_post":["post-1"]}},{"name":"hover_post_list_link_color","label":"Hover List Link Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-item--inner .item--meta li a:hover":"color: {{VALUE}}; text-decoration: underline {{VALUE}};"},"condition":{"post_type":["post"],"layout_post":["post-1"]}},{"name":"darkmode_post_list_link_color","label":"List Link Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-grid .pxl-item--inner .item--meta li a":"color: {{VALUE}};"},"condition":{"post_type":["post"],"layout_post":["post-1"]}},{"name":"darkmode_hover_post_list_link_color","label":"Hover List Link Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-grid .pxl-item--inner .item--meta li a:hover":"color: {{VALUE}}; text-decoration: underline {{VALUE}};"},"condition":{"post_type":["post"],"layout_post":["post-1"]}},{"name":"list_bottom_spacer","label":"List Bottom Spacer (Px)","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-grid .pxl-item--inner .item--meta":"margin-bottom: {{SIZE}}{{UNIT}};"},"condition":{"post_type":["post"],"layout_post":["post-1"]}},{"name":"post_title_color","label":"Title Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-item--inner .item--title a":"color: {{VALUE}};"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1"]}]},{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1","service-2"]}]}]}},{"name":"post_title_color_hover","label":"Hover Title Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-item--inner .item--title a:hover":"color: {{VALUE}}; text-decoration-color: {{VALUE}}; -webkit-text-decoration-color: {{VALUE}}; -moz-text-decoration-color: {{VALUE}}; -ms-text-decoration-color: {{VALUE}}; -o-text-decoration-color: {{VALUE}};"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1"]}]},{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1","service-2"]}]}]}},{"name":"darkmode_post_title_color","label":"Title Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-grid .pxl-item--inner .item--title a":"color: {{VALUE}};"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1"]}]},{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1","service-2"]}]}]}},{"name":"darkmode_post_title_color_hover","label":"Hover Title Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-grid .pxl-item--inner .item--title a:hover":"color: {{VALUE}}; text-decoration-color: {{VALUE}}; -webkit-text-decoration-color: {{VALUE}}; -moz-text-decoration-color: {{VALUE}}; -ms-text-decoration-color: {{VALUE}}; -o-text-decoration-color: {{VALUE}};"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1"]}]},{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1","service-2"]}]}]}},{"name":"post_title_typography","label":"Title Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-item--inner .item--title","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1"]}]},{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1","service-2"]}]}]}},{"name":"post_title_max_width","label":"Title Max Width","type":"slider","control_type":"responsive","size_units":["px","%"],"default":{"unit":"px"},"range":{"px":{"min":0,"max":3000},"%":{"min":0,"max":100}},"selectors":{"{{WRAPPER}} .pxl-grid .pxl-item--inner .item--title":"max-width: {{SIZE}}{{UNIT}};"}},{"name":"post_title_bottom_spacer","label":"Title Bottom Spacer (px)","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-grid .pxl-item--inner .item--title":"margin-bottom: {{SIZE}}{{UNIT}};"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1"]}]},{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1","service-2"]}]}]}},{"name":"post_excerpt_color","label":"Excerpt Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-item--inner .item--excerpt":"color: {{VALUE}};"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1"]}]},{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1","service-2"]}]}]}},{"name":"darkmode_post_excerpt_color","label":"Excerpt Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-grid .pxl-item--inner .item--excerpt":"color: {{VALUE}};"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1"]}]},{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1","service-2"]}]}]}},{"name":"post_excerpt_typography","label":"Excerpt Typography","type":"typography","control_type":"group","selectors":["{{WRAPPER}} .pxl-grid .pxl-item--inner .item--excerpt"],"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1"]}]},{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1","service-2"]}]}]}},{"name":"post_excerpt_bottom_spacer","label":"Excerpt Bottom Spacer (px)","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-grid .pxl-item--inner .item--excerpt":"margin-bottom: {{SIZE}}{{UNIT}};"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1"]}]},{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1","service-2"]}]}]}},{"name":"post_button_color1","label":"Button Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-item--inner .pxl-item--holder .pxl-btn-line":"color: {{VALUE}};"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1"]}]}]}},{"name":"darkmode_post_button_color1","label":"Button Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-grid .pxl-item--holder .pxl-btn-line":"color: {{VALUE}};"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1"]}]}]}},{"name":"hover_post_button_color1","label":"Hover Button Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-item--inner .pxl-item--holder .pxl-btn-line:hover":"color: {{VALUE}};"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1"]}]}]}},{"name":"darkmode_hover_post_button_color1","label":"Hover Button Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-grid .pxl-item--holder .pxl-btn-line:hover":"color: {{VALUE}};"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1"]}]}]}},{"name":"btn_typography_1","label":"Button Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-item--holder .pxl-btn-line","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-1"]}]}]}},{"name":"post_button_color2","label":"Button Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-item--inner .pxl-button":"color: {{VALUE}};","{{WRAPPER}} .pxl-grid .pxl-item--inner .pxl-button span":"text-decoration: underline {{VALUE}};"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-2"]}]}]}},{"name":"darkmode_post_button_color2","label":"Button Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-grid .pxl-item--inner .pxl-button":"color: {{VALUE}};",".dark-mode {{WRAPPER}} .pxl-grid .pxl-item--inner .pxl-button span":"text-decoration: underline {{VALUE}};"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-2"]}]}]}},{"name":"btn_typography_2","label":"Button Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-item--inner .pxl-button","conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"service"},{"name":"layout_service","operator":"in","value":["service-2"]}]}]}},{"name":"post_button_color3","label":"Button Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-btn-line":"color: {{VALUE}};","{{WRAPPER}} .pxl-grid .pxl-btn-line:after":"background-color: {{VALUE}};"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1"]}]}]}},{"name":"darkmode_post_button_color3","label":"Button Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-grid .pxl-btn-line":"color: {{VALUE}};",".dark-mode {{WRAPPER}} .pxl-grid .pxl-btn-line:after":"background-color: {{VALUE}};"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1"]}]}]}},{"name":"hover_post_button_color3","label":"Hover Button Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-btn-line:hover":"color: {{VALUE}};","{{WRAPPER}} .pxl-grid .pxl-btn-line:hover:after":"background-color: {{VALUE}};"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1"]}]}]}},{"name":"darkmode_hover_post_button_color3","label":"Hover Button Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-grid .pxl-btn-line:hover":"color: {{VALUE}};",".dark-mode {{WRAPPER}} .pxl-grid .pxl-btn-line:hover:after":"background-color: {{VALUE}};"},"conditions":{"relation":"or","terms":[{"terms":[{"name":"post_type","operator":"==","value":"post"},{"name":"layout_post","operator":"in","value":["post-1"]}]}]}},{"name":"bg_overlay_color","label":"Background Overlay Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-item--inner .item--featured:after":"background: linear-gradient(to bottom, transparent 0%, {{VALUE}} 150%);"},"condition":{"post_type":["post"],"layout_post":["post-1"],"style":["style2"]}},{"name":"bg_overlay_height","label":"Background Overlay Height","type":"slider","control_type":"responsive","size_units":["px","%"],"default":{"unit":"px"},"range":{"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-grid .pxl-item--inner .item--featured:after":"height: {{SIZE}}{{UNIT}};"},"condition":{"post_type":["post"],"layout_post":["post-1"],"style":["style2"]}}]},{"name":"tab_style_active","label":"Active","tab":"style","condition":{"post_type":["service"],"layout_service":["service-2"]},"controls":[{"name":"post_icon_color_hover","label":"Hover Icon Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-item--holder:hover .pxl-item--icon":"-webkit-text-fill-color: {{VALUE}};"}},{"name":"darkmode_post_icon_color_hover","label":"Hover Icon Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-grid .pxl-item--holder:hover .pxl-item--icon":"-webkit-text-fill-color: {{VALUE}};"}},{"name":"post_title_color_active","label":"Title Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-item--holder:hover .item--title a":"color: {{VALUE}};"}},{"name":"darkmode_post_title_color_active","label":"Title Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-grid .pxl-item--holder:hover .item--title a":"color: {{VALUE}};"}},{"name":"post_excerpt_color_active","label":"Excerpt Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-item--holder:hover .item--excerpt":"color: {{VALUE}};"}},{"name":"darkmode_post_excerpt_color_active","label":"Excerpt Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-grid .pxl-item--holder:hover .item--excerpt":"color: {{VALUE}};"}},{"name":"post_button_color_active","label":"Button Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-item--holder:hover .pxl-button":"color: {{VALUE}};","{{WRAPPER}} .pxl-grid .pxl-item--holder:hover .pxl-button span":"text-decoration: underline {{VALUE}};"}},{"name":"darkmode_post_button_color_active","label":"Button Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-grid .pxl-item--holder:hover .pxl-button":"color: {{VALUE}};",".dark-mode {{WRAPPER}} .pxl-grid .pxl-item--holder:hover .pxl-button span":"text-decoration: underline {{VALUE}};"}}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'imagesloaded','isotope','pxl-post-grid','agria-effects' );
}