<?php

class PxlImageBox_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_image_box';
    protected $title = 'Image Box Pxl';
    protected $icon = 'eicon-image-box';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"section_layout","label":"Layout","tab":"layout","controls":[{"name":"layout","label":"Templates","type":"layoutcontrol","default":"1","options":{"1":{"label":"Layout 1","image":"https:\/\/demo.bravisthemes.com\/agria\/wp-content\/themes\/agria\/elements\/templates\/pxl_image_box\/img-layout\/layout1.jpg"}}}]},{"name":"section_content","label":"Content","tab":"content","controls":[{"name":"title","label":"Title","type":"textarea","placeholder":"Enter your title","label_block":true},{"name":"image","label":"Image","type":"media"},{"name":"btn_link","label":"Link","type":"url"},{"name":"list","label":"List Item","type":"repeater","default":[],"controls":[{"name":"item_title","label":"Item Title","type":"text","label_block":true}],"title_field":"{{{ item_title }}}"},{"name":"img_size","label":"Image Size","type":"text","description":"Enter image size (Example: \"thumbnail\", \"medium\", \"large\", \"full\" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height))."}]},{"name":"section_style","label":"Style","tab":"style","controls":[{"name":"item_active","label":"Active","type":"switcher","default":"false"},{"name":"img_max_height","label":"Image Max Height (px)","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-image-box .pxl-item--image img":"max-height: {{SIZE}}{{UNIT}};"}},{"name":"img_margin","label":"Image Margin (px)","type":"dimensions","control_type":"responsive","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-item--inner .pxl-item--image":"margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"separator":"after"},{"name":"title_color","label":"Title Color","type":"color","selectors":{"{{WRAPPER}} .pxl-image-box .pxl-item--title":"color: {{VALUE}};"}},{"name":"darkmode_title_color","label":"Title Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-image-box .pxl-item--title":"color: {{VALUE}};"}},{"name":"title_typography","label":"Title Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-image-box .pxl-item--title"},{"name":"title_margin","label":"Title Margin (px)","type":"dimensions","control_type":"responsive","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-image-box .pxl-item--content > .pxl-item--title, {{WRAPPER}} .pxl-image-box .pxl-item--content > a .pxl-item--title":"margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"separator":"after"},{"name":"content_color","label":"Content Color","type":"color","selectors":{"{{WRAPPER}} .pxl-image-box .pxl-list--content":"color: {{VALUE}};"}},{"name":"darkmode_content_color","label":"Content Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-image-box .pxl-list--content":"color: {{VALUE}};"}},{"name":"content_typography","label":"Content Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-image-box .pxl-list--content"},{"name":"content_spacer_top","label":"Content Top Spacer","type":"slider","control_type":"responsive","size_units":["px","%"],"default":{"unit":"px"},"range":{"px":{"min":0,"max":3000},"%":{"min":0,"max":100}},"selectors":{"{{WRAPPER}} .pxl-image-box .pxl-item--list li + li":"margin-top: {{SIZE}}{{UNIT}};"}},{"name":"icon_color","label":"Icon Color","type":"color","selectors":{"{{WRAPPER}} .pxl-item--inner .pxl-item--content .pxl-list--content:before":"color: {{VALUE}};"}},{"name":"icon_bg_color","label":"Icon Background Color","type":"color","selectors":{"{{WRAPPER}} .pxl-item--inner .pxl-item--content .pxl-list--content:before":"background-color: {{VALUE}};"}},{"name":"darkmode_icon_color","label":"Icon Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-item--inner .pxl-item--content .pxl-list--content:before":"color: {{VALUE}};"}},{"name":"darkmode_icon_bg_color","label":"Icon Background Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-item--inner .pxl-item--content .pxl-list--content:before":"background-color: {{VALUE}};"}},{"name":"icon_font_size","label":"Icon Font Size (px)","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-item--inner .pxl-item--content .pxl-list--content:before":"font-size: {{SIZE}}{{UNIT}};"}},{"name":"icon_size","label":"Icon Size (px)","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-item--inner .pxl-item--content .pxl-list--content:before":"width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};"}},{"name":"icon_space_right","label":"Icon Spacer Right (px)","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-item--inner .pxl-item--content .pxl-list--content:before":"margin-right: {{SIZE}}{{UNIT}};"},"separator":"after"},{"name":"bg_color","label":"Background Color","type":"color","selectors":{"{{WRAPPER}} .pxl-item--inner":"background-color: {{VALUE}};"}},{"name":"border_color","label":"Border Color","type":"color","selectors":{"{{WRAPPER}} .pxl-item--inner":"border-color: {{VALUE}};"}},{"name":"darkmode_bg_color","label":"Background Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-item--inner":"background-color: {{VALUE}};"}},{"name":"darkmode_border_color","label":"Border Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-item--inner":"border-color: {{VALUE}};"}},{"name":"box_padding","label":"Box Padding","type":"dimensions","control_type":"responsive","size_units":["px","%"],"default":{"unit":"px"},"range":{"%":{"min":0,"max":100},"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-item--inner":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"section_animation","label":"Animation","tab":"style","condition":[],"controls":[{"name":"pxl_animate","label":"Case Animate","type":"select","options":{"":"None","wow bounce":"bounce","wow flash":"flash","wow pulse":"pulse","wow rubberBand":"rubberBand","wow shake":"shake","wow swing":"swing","wow tada":"tada","wow wobble":"wobble","wow bounceIn":"bounceIn","wow bounceInDown":"bounceInDown","wow bounceInLeft":"bounceInLeft","wow bounceInRight":"bounceInRight","wow bounceInUp":"bounceInUp","wow bounceOut":"bounceOut","wow bounceOutDown":"bounceOutDown","wow bounceOutLeft":"bounceOutLeft","wow bounceOutRight":"bounceOutRight","wow bounceOutUp":"bounceOutUp","wow fadeIn":"fadeIn","wow fadeInDown":"fadeInDown","wow fadeInDownBig":"fadeInDownBig","wow fadeInLeft":"fadeInLeft","wow fadeInLeftBig":"fadeInLeftBig","wow fadeInRight":"fadeInRight","wow fadeInRightBig":"fadeInRightBig","wow fadeInUp":"fadeInUp","wow fadeInUpBig":"fadeInUpBig","wow fadeOut":"fadeOut","wow fadeOutDown":"fadeOutDown","wow fadeOutDownBig":"fadeOutDownBig","wow fadeOutLeft":"fadeOutLeft","wow fadeOutLeftBig":"fadeOutLeftBig","wow fadeOutRight":"fadeOutRight","wow fadeOutRightBig":"fadeOutRightBig","wow fadeOutUp":"fadeOutUp","wow fadeOutUpBig":"fadeOutUpBig","wow flip":"flip","wow flipInX":"flipInX","wow flipInY":"flipInY","wow flipOutX":"flipOutX","wow flipOutY":"flipOutY","wow lightSpeedIn":"lightSpeedIn","wow lightSpeedOut":"lightSpeedOut","wow rotateIn":"rotateIn","wow rotateInDownLeft":"rotateInDownLeft","wow rotateInDownRight":"rotateInDownRight","wow rotateInUpLeft":"rotateInUpLeft","wow rotateInUpRight":"rotateInUpRight","wow rotateOut":"rotateOut","wow rotateOutDownLeft":"rotateOutDownLeft","wow rotateOutDownRight":"rotateOutDownRight","wow rotateOutUpLeft":"rotateOutUpLeft","wow rotateOutUpRight":"rotateOutUpRight","wow hinge":"hinge","wow rollIn":"rollIn","wow rollOut":"rollOut","wow zoomIn":"zoomIn","wow zoomInDown":"zoomInDown","wow zoomInLeft":"zoomInLeft","wow zoomInRight":"zoomInRight","wow zoomInUp":"zoomInUp","wow zoomOut":"zoomOut","wow zoomOutDown":"zoomOutDown","wow zoomOutLeft":"zoomOutLeft","wow zoomOutRight":"zoomOutRight","wow zoomOutUp":"zoomOutUp"},"default":""},{"name":"pxl_animate_delay","label":"Animate Delay","type":"text","default":"0","description":"Enter number. Default 0ms"},{"name":"pxl_animate_duration","label":"Animation Duration","type":"number","min":0,"step":0.1000000000000000055511151231257827021181583404541015625,"default":1.1999999999999999555910790149937383830547332763671875,"description":"Default 1.2s"}]}]}';
    protected $styles = array(  );
    protected $scripts = array(  );
}