<?php

class PxlMetaBoxGrid_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_meta_box_grid';
    protected $title = 'Meta Box Grid Pxl';
    protected $icon = 'eicon-gallery-grid';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"section_layout","label":"Layout","tab":"layout","controls":[{"name":"layout","label":"Templates","type":"layoutcontrol","default":"1","options":{"1":{"label":"Layout 1","image":"https:\/\/demo.bravisthemes.com\/agria\/wp-content\/themes\/agria\/elements\/templates\/pxl_meta_box_grid\/img-layout\/layout1.jpg"},"2":{"label":"Layout 2","image":"https:\/\/demo.bravisthemes.com\/agria\/wp-content\/themes\/agria\/elements\/templates\/pxl_meta_box_grid\/img-layout\/layout2.jpg"}}}]},{"name":"section_content","label":"Content","tab":"content","controls":[{"name":"box_item","label":"Items","type":"repeater","controls":[{"name":"icon_type","label":"Icon Type","type":"select","options":{"icon":"Icon","image":"Image"},"default":"icon"},{"name":"icon","label":"Icon","type":"icons","condition":{"icon_type":"icon"}},{"name":"image","label":"Image","type":"media","condition":{"icon_type":"image"}},{"name":"title","label":"Name","type":"text","label_block":true},{"name":"desc","label":"Description","type":"textarea","rows":10,"show_label":false},{"name":"link","label":"Link","type":"url","label_block":true}],"title_field":"{{{ title }}}"},{"name":"align","label":"Alignment","type":"choose","control_type":"responsive","options":{"left":{"title":"Left","icon":"eicon-text-align-left"},"center":{"title":"Center","icon":"eicon-text-align-center"},"right":{"title":"Right","icon":"eicon-text-align-right"},"justify":{"title":"Justified","icon":"eicon-text-align-justify"}},"selectors":{"{{WRAPPER}} .pxl-meta-box-grid":"text-align: {{VALUE}};"}}]},{"name":"section_settings","label":"Grid","tab":"settings","controls":[{"name":"img_size","label":"Image Size","type":"text","description":"Enter image size (Example: \"thumbnail\", \"medium\", \"large\", \"full\" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height))."},{"name":"pxl_animate","label":"Pxl Animate","type":"select","options":{"":"None","wow bounce":"bounce","wow flash":"flash","wow pulse":"pulse","wow rubberBand":"rubberBand","wow shake":"shake","wow swing":"swing","wow tada":"tada","wow wobble":"wobble","wow bounceIn":"bounceIn","wow bounceInDown":"bounceInDown","wow bounceInLeft":"bounceInLeft","wow bounceInRight":"bounceInRight","wow bounceInUp":"bounceInUp","wow bounceOut":"bounceOut","wow bounceOutDown":"bounceOutDown","wow bounceOutLeft":"bounceOutLeft","wow bounceOutRight":"bounceOutRight","wow bounceOutUp":"bounceOutUp","wow fadeIn":"fadeIn","wow fadeInDown":"fadeInDown","wow fadeInDownBig":"fadeInDownBig","wow fadeInLeft":"fadeInLeft","wow fadeInLeftBig":"fadeInLeftBig","wow fadeInRight":"fadeInRight","wow fadeInRightBig":"fadeInRightBig","wow fadeInUp":"fadeInUp","wow fadeInUpBig":"fadeInUpBig","wow fadeOut":"fadeOut","wow fadeOutDown":"fadeOutDown","wow fadeOutDownBig":"fadeOutDownBig","wow fadeOutLeft":"fadeOutLeft","wow fadeOutLeftBig":"fadeOutLeftBig","wow fadeOutRight":"fadeOutRight","wow fadeOutRightBig":"fadeOutRightBig","wow fadeOutUp":"fadeOutUp","wow fadeOutUpBig":"fadeOutUpBig","wow flip":"flip","wow flipInX":"flipInX","wow flipInY":"flipInY","wow flipOutX":"flipOutX","wow flipOutY":"flipOutY","wow lightSpeedIn":"lightSpeedIn","wow lightSpeedOut":"lightSpeedOut","wow rotateIn":"rotateIn","wow rotateInDownLeft":"rotateInDownLeft","wow rotateInDownRight":"rotateInDownRight","wow rotateInUpLeft":"rotateInUpLeft","wow rotateInUpRight":"rotateInUpRight","wow rotateOut":"rotateOut","wow rotateOutDownLeft":"rotateOutDownLeft","wow rotateOutDownRight":"rotateOutDownRight","wow rotateOutUpLeft":"rotateOutUpLeft","wow rotateOutUpRight":"rotateOutUpRight","wow hinge":"hinge","wow rollIn":"rollIn","wow rollOut":"rollOut","wow zoomIn":"zoomIn","wow zoomInDown":"zoomInDown","wow zoomInLeft":"zoomInLeft","wow zoomInRight":"zoomInRight","wow zoomInUp":"zoomInUp","wow zoomOut":"zoomOut","wow zoomOutDown":"zoomOutDown","wow zoomOutLeft":"zoomOutLeft","wow zoomOutRight":"zoomOutRight","wow zoomOutUp":"zoomOutUp"},"default":""},{"name":"col_xs","label":"Columns XS Devices","type":"select","default":"1","options":{"1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"col_sm","label":"Columns SM Devices","type":"select","default":"2","options":{"1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"col_md","label":"Columns MD Devices","type":"select","default":"2","options":{"1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"col_lg","label":"Columns LG Devices","type":"select","default":"3","options":{"1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"col_xl","label":"Columns XL Devices","type":"select","default":"3","options":{"1":"1","2":"2","3":"3","4":"4","5":"5","6":"6"}},{"name":"col_xxl","label":"Columns XXL Devices","type":"select","default":"inherit","options":{"1":"1","2":"2","3":"3","4":"4","5":"5","6":"6","inherit":"Inherit"}},{"name":"item_padding","label":"Item Padding","type":"dimensions","size_units":["px"],"default":{"top":"20","right":"20","bottom":"20","left":"20"},"selectors":{"{{WRAPPER}} .pxl-grid-inner":"margin-top: -{{TOP}}{{UNIT}}; margin-right: -{{RIGHT}}{{UNIT}}; margin-bottom: -{{BOTTOM}}{{UNIT}}; margin-left: -{{LEFT}}{{UNIT}};","{{WRAPPER}} .pxl-grid-inner .pxl-grid-item":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"control_type":"responsive"},{"name":"gap_extra","label":"Item Gap Bottom","description":"Add extra space at bottom of each items","type":"number","default":0,"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-grid-inner .pxl-grid-item":"margin-bottom: {{VALUE}}px;"}}]},{"name":"section_style_icon","label":"Style","tab":"style","controls":[{"name":"display_style","label":"Display Style","type":"select","options":{"flex":"Flex","block":"Block"},"default":"flex","label_block":true,"selectors":{"{{WRAPPER}} .pxl-item--content":"display: {{VALUE}};"},"condition":{"layout":"1"}},{"name":"icon_color","label":"Icon Color","type":"color","selectors":{"{{WRAPPER}} .pxl-meta-box-grid .pxl-item--icon i":"color: {{VALUE}};text-fill-color: {{VALUE}};-webkit-text-fill-color: {{VALUE}};background-image: none;"}},{"name":"darkmode_icon_color","label":"Icon Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-meta-box-grid .pxl-item--icon i":"color: {{VALUE}};text-fill-color: {{VALUE}};-webkit-text-fill-color: {{VALUE}};background-image: none;"}},{"name":"icon_font_size","label":"Icon Font Size","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-meta-box-grid .pxl-item--icon i":"font-size: {{SIZE}}{{UNIT}};"}},{"name":"img_max_height","label":"Image Max Height (px)","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-meta-box-grid .pxl-item--icon img":"max-height: {{SIZE}}{{UNIT}};"}},{"name":"icon_margin","label":"Icon Margin (px)","type":"dimensions","control_type":"responsive","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-meta-box-grid .pxl-item--icon":"margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"separator":"after"},{"name":"title_color","label":"Title Color","type":"color","selectors":{"{{WRAPPER}} .pxl-meta-box-grid .pxl-item--title":"color: {{VALUE}};"}},{"name":"darkmode_title_color","label":"Title Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-meta-box-grid .pxl-item--title":"color: {{VALUE}};"}},{"name":"title_typography","label":"Title Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-meta-box-grid .pxl-item--title"},{"name":"title_margin","label":"Title Margin (px)","type":"dimensions","control_type":"responsive","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-meta-box-grid .pxl-item--title":"margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"content_margin","label":"Content Margin (px)","type":"dimensions","control_type":"responsive","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-meta-box-grid .pxl-item--content":"margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"link_color","label":"Link Color","type":"color","selectors":{"{{WRAPPER}} .pxl-meta-box-grid .pxl-item--title a":"color: {{VALUE}};"}},{"name":"darkmode_link_color","label":"Link Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-meta-box-grid .pxl-item--title a":"color: {{VALUE}};"}},{"name":"link_color_hover","label":"Hover Link Color","type":"color","selectors":{"{{WRAPPER}} .pxl-meta-box-grid .pxl-item--title a:hover":"color: {{VALUE}};"}},{"name":"darkmode_link_color_hover","label":"Hover Link Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-meta-box-grid .pxl-item--title a:hover":"color: {{VALUE}};"},"separator":"after"},{"name":"desc_color","label":"Description Color","type":"color","selectors":{"{{WRAPPER}} .pxl-meta-box-grid .pxl-item--description":"color: {{VALUE}};"}},{"name":"darkmode_description_color","label":"Description Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-meta-box-grid .pxl-item--description":"color: {{VALUE}};"}},{"name":"desc_typography","label":"Description Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-meta-box-grid .pxl-item--description"},{"name":"des_margin","label":"Description Margin (px)","type":"dimensions","control_type":"responsive","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-meta-box-grid .pxl-item--description":"margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"separator":"after"},{"name":"bg_color","label":"Background Color","type":"color","selectors":{"{{WRAPPER}} .pxl-meta-box-grid .pxl-item--inner":"background-color: {{VALUE}};"}},{"name":"darkmode_bg_color","label":"Background Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-meta-box-grid .pxl-item--inner":"background-color: {{VALUE}};"}},{"name":"box_padding","label":"Padding","type":"dimensions","size_units":["px","%"],"control_type":"responsive","default":{"unit":"px"},"range":{"%":{"min":0,"max":300},"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-meta-box-grid .pxl-item--inner":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"separator":"after"},{"name":"border_type","label":"Border Type","type":"select","options":{"":"None","solid":"Solid","double":"Double","dotted":"Dotted","dashed":"Dashed","groove":"Groove"},"selectors":{"{{WRAPPER}} .pxl-meta-box-grid .pxl-item--inner":"border-style: {{VALUE}};"}},{"name":"border_width","label":"Border Width","type":"dimensions","control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-meta-box-grid .pxl-item--inner":"border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"box_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","%"],"control_type":"responsive","default":{"unit":"px"},"range":{"%":{"min":0,"max":100},"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-meta-box-grid .pxl-item--inner":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"border_color","label":"Border Color","type":"color","selectors":{"{{WRAPPER}} .pxl-meta-box-grid .pxl-item--inner":"border-color: {{VALUE}};"}},{"name":"darkmode_border_color","label":"Border Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-meta-box-grid .pxl-item--inner":"border-color: {{VALUE}};"}}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'imagesloaded','isotope','pxl-post-grid' );
}