<?php
$editor_title = $widget->get_settings_for_display( 'title' );
$editor_title = $widget->parse_text_editor( $editor_title );

if ( ! empty( $settings['btn_link']['url'] ) ) {
    $widget->add_render_attribute( 'btn_link', 'href', $settings['btn_link']['url'] );

    if ( $settings['btn_link']['is_external'] ) {
        $widget->add_render_attribute( 'btn_link', 'target', '_blank' );
    }
    if ( $settings['btn_link']['nofollow'] ) {
        $widget->add_render_attribute( 'btn_link', 'rel', 'nofollow' );
    }
}

$img_size = '';
if(!empty($settings['img_size'])) {
    $img_size = $settings['img_size'];
} else {
    $img_size = 'full';
}
?>
<div class="pxl-banner-box pxl-banner-box2 <?php echo esc_attr($settings['style']); ?> <?php echo 'type-'.esc_attr($settings['bg_type']); ?>">
    <div class="pxl-item--inner" <?php if ( $settings['bg_type'] == 'bg' && !empty($settings['image']['id']) ) { ?>style="background-image: url(<?php echo esc_url($settings['image']['url']); ?>);"<?php } ?>>
        <?php if( $settings['bg_type'] == 'img' && !empty( $settings['image']['id'] ) ) :
            $img = pxl_get_image_by_size( array(
                'attach_id'  => $settings['image']['id'],
                'thumb_size' => $img_size,
            ) );
            $thumbnail = $img['thumbnail'];
            ?>
            <div class="pxl-item--image">
                <?php echo wp_kses_post($thumbnail); ?>
            </div>
        <?php endif; ?>
        <div class="pxl-item--content">
            <?php if($settings['show_sale_text'] == 'true') : ?>
                <div class="pxl-item--holder">
                    <h4 class="item--sale"><?php echo esc_attr($settings['sale_text']); ?></h4>
            <?php endif; ?>
            <<?php echo esc_attr($settings['title_tag']); ?> class="pxl-item--title <?php if($settings['pxl_animate'] !== 'wow letter') { echo esc_attr($settings['pxl_animate']); } ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms" data-wow-duration="<?php echo esc_attr($settings['pxl_animate_duration']); ?>s">
                <?php if(!empty($editor_title)) :
                    if($settings['pxl_animate'] == 'wow letter') {
                        $arr_str = explode(' ', $editor_title); ?>
                        <span class="pxl-item--text">
                            <?php foreach ($arr_str as $index => $value) {
                                $arr_str[$index] = '<span class="pxl-text--slide"><span class="'.$settings['pxl_animate'].'">' . $value . '</span></span>';
                            }
                            $str = implode(' ', $arr_str);
                            echo wp_kses_post($str); ?>
                        </span>
                    <?php } else {
                        echo wp_kses_post($editor_title);
                    }
                endif; ?>
            </<?php echo esc_attr($settings['title_tag']); ?>>

            <?php if($settings['show_sale_text'] == 'true') : ?>
                </div>
            <?php endif; ?>

            <?php if(isset($settings['list']) && !empty($settings['list']) && count($settings['list'])): ?>
                <div class="pxl-item--list">
                    <?php foreach ($settings['list'] as $key => $value):
                        $list_title = isset($value['list_title']) ? $value['list_title'] : '';
                        $link = isset($value['link']) ? $value['link'] : '';
                        $link_key = $widget->get_repeater_setting_key( 'list_title', 'value', $key );
                        if ( ! empty( $link['url'] ) ) {
                            $widget->add_render_attribute( $link_key, 'href', $link['url'] );

                            if ( $link['is_external'] ) {
                                $widget->add_render_attribute( $link_key, 'target', '_blank' );
                            }

                            if ( $link['nofollow'] ) {
                                $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                            }
                        }
                        $link_attributes = $widget->get_render_attribute_string( $link_key );
                        ?>

                        <?php if(! empty($link['url'] ) ) { ?><a <?php echo implode( ' ', [ $link_attributes ] ); ?>><?php } ?>
                            <span><?php echo pxl_print_html($list_title); ?></span>
                        <?php if(! empty($link['url'] ) ) { ?></a><?php } ?>

                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
            <?php if($settings['show_button'] == 'true') : ?>
                <a class="<?php if($settings['style'] == 'style1') { echo pxl_print_html('btn btn-style2', 'agria'); } else { echo pxl_print_html('pxl-btn-line', 'agria'); } ?>" <?php pxl_print_html($widget->get_render_attribute_string( 'btn_link' )); ?>>
                    <span class="<?php if($settings['style'] == 'style2') { echo pxl_print_html('pxl-wobble', 'agria'); } ?>">
                        <?php if(!empty($settings['btn_text'])) {
                            $btn_text = $settings['btn_text'];
                        } else {
                            $btn_text = pxl_print_html('Shop Now', 'agria');
                        }
                        $words = explode(' ', $btn_text);
                        foreach ($words as $word) {
                            echo '<span>' . htmlspecialchars($word) . '</span> ';
                        }
                        ?>
                    </span>
                </a>
            <?php endif; ?>
        </div>
    </div>
</div>