<?php
$custom_icon = $widget->get_setting('custom_icon');
$widget->add_render_attribute( 'wrapper', 'class', 'pxl-button' );
$widget->add_render_attribute( 'button', 'class', 'btn '.$settings['btn_style'].' '.$settings['pxl_animate'] );
if ( ! empty( $settings['link']['url'] ) ) {
    $widget->add_render_attribute( 'button', 'href', $settings['link']['url'] );

    if ( $settings['link']['is_external'] ) {
        $widget->add_render_attribute( 'button', 'target', '_blank' );
    }

    if ( $settings['link']['nofollow'] ) {
        $widget->add_render_attribute( 'button', 'rel', 'nofollow' );
    }
} ?>
<div <?php pxl_print_html($widget->get_render_attribute_string( 'wrapper' )); ?>>
    <a <?php pxl_print_html($widget->get_render_attribute_string( 'button' )); ?> data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms" data-wow-duration="<?php echo esc_attr($settings['pxl_animate_duration']); ?>s">
        <?php if($settings['button_effect'] != ''){ ?>
            <span class="pxl--btn-text pxl-wobble" data-text="<?php echo esc_attr($settings['text']); ?>" data-animation="<?php echo esc_attr($settings['button_effect']); ?>">
                <?php if(!empty($settings['text'])) {
                    $btn_text = $settings['text'];
                } else {
                    $btn_text = pxl_print_html('Click Here', 'agria');
                }
                $words = explode(' ', $btn_text);
                foreach ($words as $word) {
                    echo '<span>' . htmlspecialchars($word) . '</span> ';
                }
                ?>
            </span>
        <?php } else { ?>
            <span class="pxl--btn-text" data-text="<?php echo esc_attr($settings['text']); ?>">
                <?php echo pxl_print_html($settings['text']);?>
            </span>
        <?php } ?>
        <?php if ($settings['btn_style'] == 'btn-style2') : ?>
            <span class="top-bottom"></span>
            <span class="left-right"></span>
        <?php endif; ?>
    </a>
</div>