<?php
$html_id = pxl_get_element_id($settings);
if ( ! empty( $settings['btn_link']['url'] ) ) {
    $widget->add_render_attribute( 'btn_link', 'href', $settings['btn_link']['url'] );

    if ( $settings['btn_link']['is_external'] ) {
        $widget->add_render_attribute( 'btn_link', 'target', '_blank' );
    }
    if ( $settings['btn_link']['nofollow'] ) {
        $widget->add_render_attribute( 'btn_link', 'rel', 'nofollow' );
    }
} ?>
<div class="pxl-image-box pxl-image-box1 pxl-parent-transition <?php if($settings['item_active'] == 'true') { echo pxl_print_html('active', 'agria'); } ?> <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms" data-wow-duration="<?php echo esc_attr($settings['pxl_animate_duration']); ?>s" data-cursor="-hidden" data-cursor-stick="<?php echo esc_attr('#'.$html_id); ?>">
    <div id="<?php echo esc_attr($html_id); ?>" class="pxl-item--inner pxl-transtion">
        <?php if ( !empty($settings['image']['id']) ) : ?>
            <div class="pxl-item--image">
                <?php
                $image_size = !empty($settings['img_size']) ? $settings['img_size'] : 'full';
                $img = pxl_get_image_by_size( array(
                    'attach_id'  => $settings['image']['id'],
                    'thumb_size' => $image_size,
                ) );
                $thumbnail = $img['thumbnail'];
                echo pxl_print_html($thumbnail); ?>
            </div>
        <?php endif; ?>
        <div class="pxl-item--content">
            <?php if(!empty($settings['title'])) : ?>
                <?php if ( ! empty( $settings['btn_link']['url'] ) ) { ?><a <?php pxl_print_html($widget->get_render_attribute_string( 'btn_link' )); ?>><?php } ?>
                    <h4 class="pxl-item--title"><?php echo pxl_print_html($settings['title']); ?></h4>
                <?php if ( ! empty( $settings['btn_link']['url'] ) ) { ?></a><?php } ?>
            <?php endif; ?>
            <?php if(isset($settings['list']) && !empty($settings['list']) && count($settings['list'])): ?>
                <ul class="pxl-item--list">
                    <?php foreach ($settings['list'] as $key => $value):
                        $item_title = isset($value['item_title']) ? $value['item_title'] : '';
                        ?>
                        <?php if(!empty($item_title)) : ?>
                            <li class="pxl-list--content el-empty"> <?php echo pxl_print_html($item_title); ?></li>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </ul>
            <?php endif; ?>
            <div class="pxl-item--front">
                <?php if(!empty($settings['title'])) : ?>
                    <?php if ( ! empty( $settings['btn_link']['url'] ) ) { ?><a <?php pxl_print_html($widget->get_render_attribute_string( 'btn_link' )); ?>><?php } ?>
                    <h4 class="pxl-item--title"><?php echo pxl_print_html($settings['title']); ?></h4>
                    <?php if ( ! empty( $settings['btn_link']['url'] ) ) { ?></a><?php } ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>