<?php
if ( ! empty( $settings['item_link']['url'] ) ) {
    $widget->add_render_attribute( 'button', 'href', $settings['item_link']['url'] );

    if ( $settings['item_link']['is_external'] ) {
        $widget->add_render_attribute( 'button', 'target', '_blank' );
    }

    if ( $settings['item_link']['nofollow'] ) {
        $widget->add_render_attribute( 'button', 'rel', 'nofollow' );
    }
} ?>
<div class="pxl-meta-box pxl-meta-box2 <?php echo esc_attr($settings['style']); ?> <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms" data-wow-duration="<?php echo esc_attr($settings['pxl_animate_duration']); ?>s">
    <div class="pxl-item--inner">
        <?php if(!empty($settings['image']['id'])) :
            $image_size = !empty($settings['img_size']) ? $settings['img_size'] : 'full';
            $img  = pxl_get_image_by_size( array(
                'attach_id'  => $settings['image']['id'],
                'thumb_size' => $image_size,
                'class' => 'no-lazyload'
            ) );
            $thumbnail = $img['thumbnail'];
            ?>
            <div class="pxl-item--image">
                <?php if (!empty( $settings['item_link']['url'] ) ) { ?><a <?php pxl_print_html($widget->get_render_attribute_string( 'button' )); ?>><?php } ?>
                <?php if ( !empty( $settings['image']['url'] ) ) { echo wp_kses_post($thumbnail); } ?>
                <?php if ( !empty( $settings['item_link']['url'] ) ) { ?></a><?php } ?>
            </div>
        <?php endif; ?>
        <?php if(!empty($settings['item_sub_title']) || !empty($settings['item_title'])) : ?>
            <div class="pxl-item--content">
                <?php if(!empty($settings['item_sub_title'])) : ?>
                    <div class="pxl-item--subtitle"><?php echo esc_attr($settings['item_sub_title']); ?></div>
                <?php endif; ?>
                <?php if(!empty($settings['item_title'])) : ?>
                    <div class="pxl-item--title"><?php echo esc_attr($settings['item_title']); ?></div>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
</div>