<div class="pxl-pricing pxl-pricing1 <?php echo esc_attr( $settings['box_active'].' '.$settings['pxl_animate'] ); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <div class="pxl-meta">
        <h4 class="pxl-title"><span><?php echo esc_attr($settings['title']); ?></span></h4>
        <?php if ( !empty($settings['image']['id']) ) : ?>
            <div class="pxl-image"  data-tilt data-tilt-max="30" data-tilt-speed="750" data-tilt-scale="1.02">
                <?php $img  = pxl_get_image_by_size( array(
                    'attach_id'  => $settings['image']['id'],
                    'thumb_size' => 'full',
                ) );
                $thumbnail    = $img['thumbnail'];
                echo pxl_print_html($thumbnail); ?>
            </div>
        <?php endif; ?>
    </div>
    <?php if(isset($settings['feature']) && !empty($settings['feature']) && count($settings['feature'])): ?>
        <ul class="pxl-feature">
            <?php foreach ($settings['feature'] as $key => $value): ?>
                <li class="pxl-content <?php if(!$value['item_active']) { echo pxl_print_html('unavailable', 'agria'); } ?>">
                    <?php echo pxl_print_html($value['feature_text'])?><i class="fas fa-check"></i>
                </li>
            <?php endforeach; ?>
        </ul>
    <?php endif; ?>
    <div class="pxl-price">
        <span class="pxl-value" <?php if(!empty($settings['currency'])) { ?>data-prefix="<?php echo pxl_print_html($settings['currency']); ?>" <?php } ?> <?php if(!empty($settings['pric_day'])) { ?>data-suffix="/<?php echo pxl_print_html($settings['pric_day']); ?>" <?php } ?>><?php echo pxl_print_html($settings['price']); ?></span>
    </div>
    <?php if ( ! empty( $settings['btn_link']['url'] ) ) :
        $widget->add_render_attribute( 'btn_link', 'href', $settings['btn_link']['url'] );
        if ( $settings['btn_link']['is_external'] ) {
            $widget->add_render_attribute( 'btn_link', 'target', '_blank' );
        }
        if ( $settings['btn_link']['nofollow'] ) {
            $widget->add_render_attribute( 'btn_link', 'rel', 'nofollow' );
        }
    endif; ?>
    <a class="btn btn-default" <?php pxl_print_html($widget->get_render_attribute_string( 'btn_link' )); ?>>
        <span>
            <?php if(!empty($settings['btn_text'])) {
                echo pxl_print_html($settings['btn_text']);
            } else {
                echo pxl_print_html('Choose Package', 'agria');
            } ?>
        </span>
        <i aria-hidden="true" class="far fa-long-arrow-right"></i>
    </a>
</div>