<?php
$html_id = pxl_get_element_id($settings);
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 4);

$prod_categories = get_terms( 'product_cat', array(
    'orderby' => $orderby,
    'order' => $order,
    'number' => $limit,
    'hide_empty' => 1,
    'parent' => 0
));

$pxl_animate = $widget->get_setting('pxl_animate', '');
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$col_xxl = $widget->get_setting('col_xxl', '');
if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');

$arrows = $widget->get_setting('arrows','false');
$pagination = $widget->get_setting('pagination','false');
$pagination_type = $widget->get_setting('pagination_type','bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite');
$speed = $widget->get_setting('speed', '500');

$img_size = $widget->get_setting('img_size');

$show_cursor_text = $widget->get_setting('show_cursor_text');
$cursor_text = $widget->get_setting('cursor_text');
$data_cursor_text = '';
if(!empty($cursor_text)) {
    $data_cursor_text = $cursor_text;
} else {
    $data_cursor_text = esc_html__('◄ ►', 'agria');
}

$arrows_text_prev = $widget->get_setting('arrows_text_prev');
$arrows_text_next = $widget->get_setting('arrows_text_next');

$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => '1',
    'slide_mode'                    => 'slide',
    'slides_to_show'                => $col_xl,
    'slides_to_show_xxl'             => $col_xxl,
    'slides_to_show_lg'             => $col_lg,
    'slides_to_show_md'             => $col_md,
    'slides_to_show_sm'             => $col_sm,
    'slides_to_show_xs'             => $col_xs,
    'slides_to_scroll'              => $slides_to_scroll,
    'arrow'                         => $arrows,
    'pagination'                    => $pagination,
    'pagination_type'               => $pagination_type,

    'autoplay'                      => $autoplay,
    'pause_on_hover'                => $pause_on_hover,
    'pause_on_interaction'          => 'true',
    'delay'                         => $autoplay_speed,
    'loop'                          => $infinite,
    'speed'                         => $speed
];
$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]); ?>

<div id="<?php echo esc_attr($html_id) ?>" class="pxl-swiper-sliders pxl-product-categories-carousel pxl-product-categories-carousel1 pxl-parent-transition" data-arrow="<?php echo esc_attr($arrows); ?>">
    <div class="pxl-carousel-inner">
        <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
            <div class="pxl-swiper-wrapper">
                <?php
                foreach ($prod_categories as $prod_cat):
                    if(class_exists('Woocommerce')) {
                        $img_id = get_term_meta( $prod_cat->term_id, 'thumbnail_id', true );
                        $term_link = get_term_link( $prod_cat, 'product_cat' );
                        $image_size = !empty($img_size) ? $img_size : 'full'; ?>
                        <div class="pxl-swiper-slide <?php if($show_cursor_text == 'true') { echo 'pxl-no-cursor'; } ?>">
                            <div class="pxl-item--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms" data-wow-duration="<?php echo esc_attr($settings['pxl_animate_duration']); ?>s">
                                <?php if(!empty($img_id)) {
                                    $img = pxl_get_image_by_size( array(
                                        'attach_id'  => $img_id,
                                        'thumb_size' => $image_size,
                                         'class' => 'no-lazyload',
                                    ) );
                                    $thumbnail = $img['thumbnail']; ?>
                                    <a href="<?php echo esc_attr($term_link); ?>" title="<?php echo esc_attr($prod_cat->name); ?>">
                                        <div class="item--image <?php if($show_cursor_text == 'true') { echo 'pxl-no-cursor'; } ?>" <?php if($show_cursor_text == 'true') { echo 'data-cursor-text="'.esc_attr($data_cursor_text).'"'; } ?>>
                                            <?php echo wp_kses_post($thumbnail); ?>
                                        </div>
                                    </a>
                                <?php } ?>
                                <div class="item--content">
                                    <a href="<?php echo esc_attr($term_link); ?>" title="<?php echo esc_attr($prod_cat->name); ?>">
                                        <h4 class="item--title pxl-wobble pxl-transtion">
                                            <?php $words = explode(' ', $prod_cat->name);
                                            foreach ($words as $word) {
                                                echo '<span>' . htmlspecialchars($word) . '</span> ';
                                            } ?>
                                        </h4>
                                    </a>
                                    <h6 class="item--count"><?php echo '('. $prod_cat->count. ')'; ?></h6>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                <?php endforeach; wp_reset_query(); ?>
            </div>
        </div>
        <?php if($arrows !== 'false'): ?>
            <div class="pxl-swiper-arrow pxl-swiper-arrow-prev pxl-no-cursor" data-cursor="-lg" <?php echo 'data-cursor-text="'.esc_attr($arrows_text_prev).'"'; ?>>
                <i class="far fa-arrow-left"></i>
            </div>
            <div class="pxl-swiper-arrow pxl-swiper-arrow-next pxl-no-cursor" data-cursor="-lg" <?php echo 'data-cursor-text="'.esc_attr($arrows_text_next).'"'; ?>>
                <i class="far fa-arrow-right"></i>
            </div>
        <?php endif; ?>
        <?php if($pagination !== 'false'): ?>
            <div class="pxl-swiper-dots"></div>
        <?php endif; ?>
    </div>
</div>