<?php
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$col_xxl = $widget->get_setting('col_xxl', '');
if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');
$arrows = $widget->get_setting('arrows','false');
$arrows_style = $widget->get_setting('arrows_style','style1');
$pagination = $widget->get_setting('pagination','false');
$pagination_type = $widget->get_setting('pagination_type','bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay', '');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite','false');
$speed = $widget->get_setting('speed', '500');

$show_cursor_text = $widget->get_setting('show_cursor_text');
$cursor_text = $widget->get_setting('cursor_text');

$data_cursor_text = '';
if(!empty($cursor_text)) {
    $data_cursor_text = $cursor_text;
} else {
    $data_cursor_text = esc_html__('◄ ►', 'agria');
}
$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => '1',
    'slide_mode'                    => 'slide',
    'slides_to_show'                => $col_xl,
    'slides_to_show_xxl'             => $col_xxl,
    'slides_to_show_lg'             => $col_lg,
    'slides_to_show_md'             => $col_md,
    'slides_to_show_sm'             => $col_sm,
    'slides_to_show_xs'             => $col_xs,
    'slides_to_scroll'              => $slides_to_scroll,
    'arrow'                         => $arrows,
    'pagination'                    => $pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => $autoplay,
    'pause_on_hover'                => $pause_on_hover,
    'pause_on_interaction'          => 'true',
    'delay'                         => $autoplay_speed,
    'loop'                          => $infinite,
    'speed'                         => $speed
];
$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]);
if(isset($settings['testimonial2']) && !empty($settings['testimonial2']) && count($settings['testimonial2'])): ?>
    <div class="pxl-swiper-sliders pxl-testimonial-carousel pxl-testimonial-carousel2 pxl-parent-transition pxl-swiper-arrow-show <?php if($arrows == 'true') { echo esc_attr__( 'pxl-show-arrow', 'agria' ); } ?>" data-view-auto="<?php echo esc_attr($col_xl); ?>">
        <?php if(!empty($settings['el_title_text']) || !empty($settings['el_sub_title']) || $arrows == 'true') : ?>
            <div class="container-custom">
                <?php if($arrows == 'true' && $arrows_style == 'style1') { ?>
                    <div class="col-sm-8 col-12">
                <?php } else { ?>
                    <div class="col-12">
                <?php } ?>
                    <?php if(!empty($settings['el_title_text']) || !empty($settings['el_sub_title'])) : ?>
                        <div class="wp-title">
                            <?php if(!empty($settings['el_sub_title'])) : ?>
                                <div class="el--sub-title <?php echo esc_attr($settings['el_animate_sub']); ?>" data-wow-delay="<?php echo esc_attr($settings['el_animate_delay_sub']); ?>ms" data-wow-duration="<?php echo esc_attr($settings['el_animate_duration_sub']); ?>s"><?php echo pxl_print_html($settings['el_sub_title']); ?></div>
                            <?php endif; ?>
                            <?php if(!empty($settings['el_title_text'])) :
                                $editor_title = $widget->get_settings_for_display( 'el_title_text' );
                                $editor_title = $widget->parse_text_editor( $editor_title );
                                ?>
                                <<?php echo esc_attr($settings['el_title_tag']); ?> class="el--title <?php if($settings['el_animate'] !== 'wow letter') { echo esc_attr($settings['el_animate']); } ?>" data-wow-delay="<?php echo esc_attr($settings['el_animate_delay']); ?>ms" data-wow-duration="<?php echo esc_attr($settings['el_animate_duration']); ?>s">
                                <?php if($settings['el_animate'] == 'wow letter') {
                                        $arr_str = explode(' ', $editor_title); ?>
                                        <span class="pxl-item--text">
                                            <?php foreach ($arr_str as $index => $value) {
                                                $arr_str[$index] = '<span class="pxl-text--slide"><span class="'.$settings['el_animate'].'">' . $value . '</span></span>';
                                            }
                                            $str = implode(' ', $arr_str);
                                            echo wp_kses_post($str); ?>
                                        </span>
                                    <?php } else {
                                        echo wp_kses_post($editor_title);
                                    }
                                ?>
                                </<?php echo esc_attr($settings['el_title_tag']); ?>>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
                <?php if($arrows == 'true' && $arrows_style == 'style1'): ?>
                    <div class="col-sm-4 col-12">
                        <div class="wp-arrow style1" data-cursor="-hidden">
                            <div class="pxl-swiper-arrow pxl-swiper-arrow-prev"><i class="far fa-arrow-left"></i></div>
                            <div class="pxl-swiper-arrow pxl-swiper-arrow-next"><i class="far fa-arrow-right"></i></div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>
        <div class="pxl-carousel-inner">
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper" <?php if($show_cursor_text == 'true') { echo 'data-cursor-text="'.esc_attr($data_cursor_text).'"'; } ?>>
                    <?php foreach ($settings['testimonial2'] as $key => $value):
                        $style = isset($value['style']) ? $value['style'] : '';
                        $show_star = isset($value['show_star']) ? $value['show_star'] : '';
                        $star = isset($value['star']) ? $value['star'] : '';
                        $show_icon = isset($value['show_icon']) ? $value['show_icon'] : '';
                        $icon = isset($value['icon2']) ? $value['icon2'] : '';
                        $title2 = isset($value['title2']) ? $value['title2'] : '';
                        $desc2 = isset($value['desc2']) ? $value['desc2'] : '';
                        $image = isset($value['image2']) ? $value['image2'] : '';
                        $img_size = isset($settings['img_size']) ? $settings['img_size'] : '';
                        $image_size = !empty($img_size) ? $img_size : 'full';
                        $author2 = isset($value['author2']) ? $value['author2'] : '';
                        $position2 = isset($value['position2']) ? $value['position2'] : '';
                        ?>
                        <div class="pxl-swiper-slide <?php echo esc_attr($style); ?> <?php if($show_cursor_text == 'true') { echo 'pxl-no-cursor'; } ?>">
                            <div class="pxl-item--inner pxl-transtion <?php echo esc_attr($style); ?> <?php if($show_cursor_text == 'true') { echo 'pxl-no-cursor'; } ?> <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms" data-wow-duration="<?php echo esc_attr($settings['pxl_animate_duration']); ?>s">
                                <?php if( $show_star == 'true' ) : ?>
                                    <span class="pxl-item--star <?php echo esc_attr($star); ?>">
                                        <i class="fas fa-star"></i>
                                        <i class="fas fa-star"></i>
                                        <i class="fas fa-star"></i>
                                        <i class="fas fa-star"></i>
                                        <i class="fas fa-star"></i>
                                    </span>
                                <?php endif; ?>
                                <?php if(!empty($title2)) : ?>
                                    <h6 class="pxl-item--title el-empty"><?php echo pxl_print_html($title2); ?></h6>
                                <?php endif; ?>
                                <?php if(!empty($desc2)) : ?>
                                    <?php if( $show_icon == 'true' && !empty($icon['value']) ) : ?>
                                        <div class="pxl-item--holder">
                                            <div class="pxl-item--icon"><?php \Elementor\Icons_Manager::render_icon( $icon, [ 'aria-hidden' => 'true', 'class' => '' ], 'i' ); ?></div>
                                        <?php endif; ?>
                                        <div class="pxl-item--desc el-empty <?php echo esc_attr($settings['pxl_animate_description']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay_description']); ?>ms" data-wow-duration="<?php echo esc_attr($settings['pxl_animate_duration_description']); ?>s"><?php echo pxl_print_html($desc2); ?></div>
                                        <?php if( $show_icon == 'true' ) { ?>
                                        </div>
                                    <?php } ?>
                                <?php endif; ?>
                                <?php if( $show_icon == 'true' && !empty($icon['value']) ) : ?>
                                    <div class="pxl-item--holder">
                                        <div class="pxl-item--icon pxl-opacity"><?php \Elementor\Icons_Manager::render_icon( $icon, [ 'aria-hidden' => 'true', 'class' => '' ], 'i' ); ?></div>
                                    <?php endif; ?>
                                    <div class="pxl-item-content">
                                        <?php if(!empty($image['id'])) {
                                            $img = pxl_get_image_by_size( array(
                                                'attach_id'  => $image['id'],
                                                'thumb_size' => $image_size,
                                                'class' => 'no-lazyload',
                                            ));
                                            $thumbnail = $img['thumbnail'];
                                            ?>
                                            <div class="pxl-author--image"><?php echo wp_kses_post($thumbnail); ?></div>
                                        <?php } ?>
                                        <div class="pxl-content-inner">
                                            <?php if(!empty($author2)) : ?>
                                                <div class="pxl-item--author el-empty <?php echo esc_attr($settings['pxl_animate_author']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay_author']); ?>ms" data-wow-duration="<?php echo esc_attr($settings['pxl_animate_duration_author']); ?>s"><?php echo pxl_print_html($author2); ?></div>
                                            <?php endif; ?>
                                            <?php if(!empty($position2)) : ?>
                                                <div class="pxl-item--position el-empty <?php echo esc_attr($settings['pxl_animate_position']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay_position']); ?>ms" data-wow-duration="<?php echo esc_attr($settings['pxl_animate_duration_position']); ?>s"><?php echo pxl_print_html($position2); ?></div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <?php if( $show_icon == 'true' ) { ?>
                                    </div>
                                <?php } ?>
                           </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
            <?php if($pagination !== 'false'): ?>
                <div class="pxl-swiper-dots"></div>
            <?php endif; ?>
            <?php if($arrows == 'true' && $arrows_style == 'style2'): ?>
                <div class="wp-arrow" data-cursor="-hidden">
                    <div class="pxl-swiper-arrow pxl-swiper-arrow-prev"><i class="far fa-arrow-left"></i></div>
                    <div class="pxl-swiper-arrow pxl-swiper-arrow-next"><i class="far fa-arrow-right"></i></div>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php endif; ?>
