<?php
/**
 * Filters hook for the theme
 *
 * @package Bravisthemes
 */

add_filter( 'pxl_server_info', 'agria_add_server_info');
function agria_add_server_info($infos){
  $infos = [
    'api_url' => 'https://api.bravisthemes.com/',
    'docs_url' => 'https://doc.bravisthemes.com/agria/',
    'plugin_url' => 'https://api.bravisthemes.com/plugins/',
    'demo_url' => 'https://demo.bravisthemes.com/agria/',
    'support_url' => 'https://bravisthemes.ticksy.com/',
    'help_url' => 'https://doc.bravisthemes.com/',
    'email_support' => '',
    'video_url' => '#'
  ];

  return $infos;
}

/* Custom Classs - Body */
function agria_body_classes( $classes ) {

    if (class_exists('ReduxFramework')) {
        $classes[] = ' pxl-redux-page';
    }

    $footer_fixed = agria()->get_theme_opt('footer_fixed');
    if(isset($footer_fixed) && $footer_fixed) {
        $classes[] = ' pxl-footer-fixed';
    }

    $smooth_scroll = agria()->get_theme_opt('smooth_scroll');
    if($smooth_scroll) {
        $classes[] = ' pxl-smooth-scroll';
    }

    $light_dark_switch = agria()->get_theme_opt('light_dark_switch');
    if($light_dark_switch == 'pxl-dark-mode') {
        $classes[] = ' dark-mode';
    }

    return $classes;
}
add_filter( 'body_class', 'agria_body_classes' );

/* Post Type Support Elementor*/
add_filter( 'pxl_add_cpt_support', 'agria_add_cpt_support' );
function agria_add_cpt_support($cpt_support) {
	$cpt_support[] = 'service';
	$cpt_support[] = 'pxl-slider';
    return $cpt_support;
}

add_filter( 'pxl_support_default_cpt', 'agria_support_default_cpt' );
function agria_support_default_cpt($postypes){
	return $postypes; // pxl-template
}

add_filter( 'pxl_extra_post_types', 'agria_add_posttype' );
function agria_add_posttype( $postypes ) {
	$postypes['portfolio'] = array(
		'status' => true,
		'item_name'  => 'Portfolio',
		'items_name' => 'Portfolio',
		'args'       => array(
			'rewrite'             => array(
                'slug'       => 'portfolio',
 		 	),
		),
	);

	$postypes['service'] = array(
		'status' => true,
		'item_name'  => 'Service',
		'items_name' => 'Service',
		'args'       => array(
			'rewrite'             => array(
                'slug'       => 'service',
 		 	),
		),
	);
    $postypes['pxl-slider'] = [
        'status'     => true,
        'item_name'  => esc_html__('Slider Builder', 'agria'),
		'items_name' => esc_html__('Slider Builder', 'agria'),
        'args'       => array(
            'supports'           => array(
                'title',
                'editor',
            ),
            'public'             => true,
            'publicly_queryable' => true,
            'show_in_nav_menus'   => false
        ),
        'labels'     => array()
    ];
	return $postypes;
}

add_filter( 'pxl_extra_taxonomies', 'agria_add_tax' );
function agria_add_tax( $taxonomies ) {
	$taxonomies['portfolio-category'] = array(
		'status'     => true,
		'post_type'  => array( 'portfolio' ),
		'taxonomy'   => 'Portfolio Categories',
		'taxonomies' => 'Portfolio Categories',
		'args'       => array(
			'rewrite'             => array(
                'slug'       => 'portfolio-category'
 		 	),
		),
		'labels'     => array()
	);
	$taxonomies['portfolio-tag'] = array(
		'status'     => true,
		'post_type'  => array( 'portfolio' ),
		'taxonomy'   => 'Portfolio Tags',
		'taxonomies' => 'Portfolio Tags',
		'args'       => array(
			'rewrite'             => array(
                'slug'       => 'portfolio-tag'
 		 	),
		),
		'labels'     => array()
	);

	$taxonomies['service-category'] = array(
		'status'     => true,
		'post_type'  => array( 'service' ),
		'taxonomy'   => 'Service Categories',
		'taxonomies' => 'Service Categories',
		'args'       => array(
			'rewrite'             => array(
                'slug'       => 'service-category'
 		 	),
		),
		'labels'     => array()
	);
	$taxonomies['service-tag'] = array(
		'status'     => true,
		'post_type'  => array( 'service' ),
		'taxonomy'   => 'Service Tags',
		'taxonomies' => 'Service Tags',
		'args'       => array(
			'rewrite'             => array(
                'slug'       => 'service-tag'
 		 	),
		),
		'labels'     => array()
	);

	return $taxonomies;
}

add_filter( 'pxl_theme_builder_post_types', 'agria_theme_builder_post_type' );
function agria_theme_builder_post_type($postypes){
	//default are header, footer, mega-menu
	$postypes[] = 'pxl-slider';
	return $postypes;
}

add_filter( 'pxl_theme_builder_layout_ids', 'agria_theme_builder_layout_id' );
function agria_theme_builder_layout_id($layout_ids){
	//default [],
	$header_layout        = (int)agria()->get_opt('header_layout');
	$header_sticky_layout = (int)agria()->get_opt('header_sticky_layout');
	$footer_layout        = (int)agria()->get_opt('footer_layout');
	$ptitle_layout        = (int)agria()->get_opt('ptitle_layout');
	$shop_layout  		  = (int)agria()->get_opt('shop_layout');
	$shop_single_layout   = (int)agria()->get_opt('shop_single_layout');
	if( $header_layout > 0)
		$layout_ids[] = $header_layout;
	if( $header_sticky_layout > 0)
		$layout_ids[] = $header_sticky_layout;
	if( $footer_layout > 0)
		$layout_ids[] = $footer_layout;
	if( $ptitle_layout > 0)
		$layout_ids[] = $ptitle_layout;
	if( $shop_layout > 0)
		$layout_ids[] = $shop_layout;
	if( $shop_single_layout > 0)
		$layout_ids[] = $shop_single_layout;

	return $layout_ids;
}

add_filter( 'pxl_wg_get_source_id_builder', 'agria_wg_get_source_builder' );
function agria_wg_get_source_builder($wg_datas){
  $wg_datas['tabs'] = ['control_name' => 'tabs', 'source_name' => 'content_template'];
  return $wg_datas;
}

add_filter( 'pxl_template_type_support', 'agria_template_type_support' );
function agria_template_type_support($type){
	//default ['header','footer','mega-menu']
	$extra_type = [
        'page-title'   => esc_html__('Page Title', 'agria'),
        'hidden-panel' => esc_html__('Hidden Panel', 'agria'),
        'tab'          => esc_html__('Tab', 'agria'),
	];
	$template_type = array_merge($type,$extra_type);
	return $template_type;
}


add_filter( 'get_the_archive_title', 'agria_archive_title_remove_label' );
function agria_archive_title_remove_label( $title ) {
	if ( is_category() ) {
		$title = single_cat_title( '', false );
	} elseif ( is_tag() ) {
		$title = single_tag_title( '', false );
	} elseif ( is_author() ) {
		$title = get_the_author();
	} elseif ( is_post_type_archive() ) {
		$title = post_type_archive_title( '', false );
	} elseif ( is_tax() ) {
		$title = single_term_title( '', false );
	} elseif ( is_home() ) {
		$title = single_post_title( '', false );
	}

	return $title;
}

add_filter( 'comment_reply_link', 'agria_comment_reply_link' );
function agria_comment_reply_link( $content ) {
    $extra_classes = 'pxl-btn-line';
    return preg_replace( '/comment-reply-link/', 'comment-reply-link ' . $extra_classes, $content);
}

add_filter( 'pxl_enable_megamenu', 'agria_enable_megamenu' );
function agria_enable_megamenu() {
	return true;
}
add_filter( 'pxl_enable_onepage', 'agria_enable_onepage' );
function agria_enable_onepage() {
	return true;
}

add_filter( 'pxl_support_awesome_pro', 'agria_support_awesome_pro' );
function agria_support_awesome_pro() {
	return true;
}

add_filter( 'redux_pxl_iconpicker_field/get_icons', 'agria_add_icons_to_pxl_iconpicker_field' );
function agria_add_icons_to_pxl_iconpicker_field($icons){
	$custom_icons = []; //'Flaticon' => array(array('flaticon-marker' => 'flaticon-marker')),
	$icons = array_merge($custom_icons, $icons);
	return $icons;
}


add_filter("pxl_mega_menu/get_icons", "agria_add_icons_to_megamenu");
function agria_add_icons_to_megamenu($icons){
	$custom_icons = []; //'Flaticon' => array(array('flaticon-marker' => 'flaticon-marker')),
	$icons = array_merge($custom_icons, $icons);
	return $icons;
}


/**
 * Move comment field to bottom
 */
add_filter( 'comment_form_fields', 'agria_comment_field_to_bottom' );
function agria_comment_field_to_bottom( $fields ) {
	$comment_field = $fields['comment'];
	unset( $fields['comment'] );
	$fields['comment'] = $comment_field;
	return $fields;
}


/* ------Disable Lazy loading---- */
add_filter( 'wp_lazy_loading_enabled', '__return_false' );
