<?php
/**
 * @package Bravisthemes
 */
$archive_readmore_text = agria()->get_theme_opt('archive_readmore_text', esc_html__('Read More', 'agria'));
$archive_excerpt_on = agria()->get_theme_opt('archive_excerpts', true);
$archive_excerpt = get_the_excerpt($post->ID);
$thumbnail_url = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false);
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('pxl-item--archive'); ?>>
    <?php if (has_post_thumbnail()) {
        echo '<div class="item--featured">'; ?>
            <a href="<?php echo esc_url( get_permalink()); ?>"><?php the_post_thumbnail('agria-thumb-medium'); ?></a>
        <?php echo '</div>';
    } ?>
    <div class="item--holder">
        <?php agria()->blog->get_archive_meta(); ?>
        <h5 class="item--title">
            <a href="<?php echo esc_url( get_permalink()); ?>" title="<?php the_title_attribute(); ?>">
                <?php if(is_sticky()) { ?>
                    <i class="caseicon-check-mark"></i>
                <?php } ?>
                <?php the_title(); ?>
            </a>
        </h5>
        <?php if($archive_excerpt_on && !empty($archive_excerpt)): ?>
            <div class="item--excerpt">
                <?php
                    agria()->blog->get_excerpt();
                    wp_link_pages( array(
                        'before'      => '<div class="page-links">',
                        'after'       => '</div>',
                        'link_before' => '<span>',
                        'link_after'  => '</span>',
                    ) );
                ?>
            </div>
        <?php endif; ?>
        <a class="pxl-btn-line" href="<?php echo esc_url( get_permalink()); ?>">
            <span class="pxl-wobble">
                <?php $words = explode(' ', $archive_readmore_text);
                foreach ($words as $word) {
                    echo '<span>' . htmlspecialchars($word) . '</span> ';
                }
                ?>
            </span>
        </a>
    </div>
</article>