<?php

class PxlMetaBox_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_meta_box';
    protected $title = 'Meta Box Pxl';
    protected $icon = 'eicon-icon-box';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"section_layout","label":"Layout","tab":"layout","controls":[{"name":"layout","label":"Templates","type":"layoutcontrol","default":"1","options":{"1":{"label":"Layout 1","image":"https:\/\/glansadesigns.com\/testing\/risenew\/wp-content\/themes\/agria\/elements\/templates\/pxl_meta_box\/img-layout\/layout1.jpg"},"2":{"label":"Layout 2","image":"https:\/\/glansadesigns.com\/testing\/risenew\/wp-content\/themes\/agria\/elements\/templates\/pxl_meta_box\/img-layout\/layout2.jpg"}}}]},{"name":"section_content","label":"Content","tab":"content","condition":{"layout":["1"]},"controls":[{"name":"title","label":"Title","type":"text","label_block":true},{"name":"btn_text","label":"Button Text","type":"text","placeholder":"Customer Application"},{"name":"btn_link","label":"Button Link","type":"url","default":{"url":"#"}},{"name":"style","label":"Style","type":"select","options":{"style1":"Style 1","style2":"Style 2"},"default":"style1"}]},{"name":"section_content_layout2","label":"Content","tab":"content","condition":{"layout":["2"]},"controls":[{"name":"image","label":"Choose Image","type":"media"},{"name":"item_sub_title","label":"Sub Title","type":"text","label_block":true},{"name":"item_title","label":"Title","type":"text","label_block":true},{"name":"item_link","label":"Item Link","type":"url","default":{"url":"#"}},{"name":"img_size","label":"Image Size","type":"text","description":"Enter image size (Example: &quot;thumbnail&quot;, &quot;medium&quot;, &quot;large&quot;, &quot;full&quot; or other sizes defined by theme). Alternatively enter size in pixels (Example: 200x100 (Width x Height)."}]},{"name":"section_style_title","label":"Title","tab":"style","controls":[{"name":"title_tag","label":"HTML Tag","type":"select","options":{"h1":"H1","h2":"H2","h3":"H3","h4":"H4","h5":"H5","h6":"H6","div":"div","span":"span","p":"p"},"default":"h4","condition":{"layout":["1"]}},{"name":"sub_title_color","label":"Sub Title Color","type":"color","selectors":{"{{WRAPPER}} .pxl-meta-box .pxl-item--subtitle":"color: {{VALUE}};"}},{"name":"darkmode_sub_title_color","label":"Sub Title Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-meta-box .pxl-item--subtitle":"color: {{VALUE}};"}},{"name":"sub_title_typography","label":"Sub Title Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-meta-box .pxl-item--subtitle"},{"name":"title_color","label":"Title Color","type":"color","selectors":{"{{WRAPPER}} .pxl-meta-box .pxl-item--title":"color: {{VALUE}};"}},{"name":"darkmode_title_color","label":"Title Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-meta-box .pxl-item--title":"color: {{VALUE}};"}},{"name":"title_typography","label":"Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-meta-box .pxl-item--title"},{"name":"title_margin","label":"Title Margin (px)","type":"dimensions","control_type":"responsive","size_units":["px","%"],"default":{"unit":"px"},"range":{"px":{"min":0,"max":3000},"%":{"min":0,"max":100}},"selectors":{"{{WRAPPER}} .pxl-meta-box .pxl-item--title":"margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"separator":"after"}]},{"name":"section_style_button","label":"Button","tab":"style","condition":{"layout":["1"]},"controls":[{"name":"button_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-item--inner .btn":"color: {{VALUE}};"}},{"name":"button_bg_color","label":"Background Color","type":"color","selectors":{"{{WRAPPER}} .pxl-item--inner .btn":"background-color: {{VALUE}};"}},{"name":"button_border_color","label":"Border Color","type":"color","selectors":{"{{WRAPPER}} .pxl-item--inner .btn:after":"border-color: {{VALUE}};"}},{"name":"darkmode_button_color","label":"Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-item--inner .btn":"color: {{VALUE}};"},"separator":"before"},{"name":"darkmode_button_bg_color","label":"Background Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-item--inner .btn":"background-color: {{VALUE}};"}},{"name":"darkmode_button_border_color","label":"Border Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-item--inner .btn:after":"border-color: {{VALUE}};"}},{"name":"button_color_hover","label":"Hover Color","type":"color","selectors":{"{{WRAPPER}} .pxl-item--inner .btn:hover":"color: {{VALUE}};"},"separator":"before"},{"name":"button_bg_color_hover","label":"Hover Background Color","type":"color","selectors":{"{{WRAPPER}} .pxl-item--inner .btn:hover":"background-color: {{VALUE}};"}},{"name":"button_border_color_hover","label":"Hover Border Color","type":"color","selectors":{"{{WRAPPER}} .pxl-item--inner .btn:hover:after":"border-color: {{VALUE}};"}},{"name":"darkmode_button_color_hover","label":"Hover Color Hover (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-item--inner .btn:hover":"color: {{VALUE}};"},"separator":"before"},{"name":"darkmode_button_bg_color_hover","label":"Hover Background Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-item--inner .btn:hover":"background-color: {{VALUE}};"}},{"name":"darkmode_button_border_color_hover","label":"Hover Border Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-item--inner .btn:hover:after":"border-color: {{VALUE}};"}}]},{"name":"section_style_box","label":"Box Setting","tab":"style","controls":[{"name":"bg_color","label":"Background Color","type":"color","selectors":{"{{WRAPPER}} .pxl-item--inner":"background-color: {{VALUE}};"}},{"name":"darkmode_bg_color","label":"Background Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-item--inner":"background-color: {{VALUE}};"}},{"name":"box_padding","label":"Box Padding","type":"dimensions","control_type":"responsive","size_units":["px","%"],"default":{"unit":"px"},"range":{"px":{"min":0,"max":3000},"%":{"min":0,"max":100}},"selectors":{"{{WRAPPER}} .pxl-item--inner":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"align","label":"Alignment","type":"choose","control_type":"responsive","options":{"left":{"title":"Left","icon":"eicon-text-align-left"},"center":{"title":"Center","icon":"eicon-text-align-center"},"right":{"title":"Right","icon":"eicon-text-align-right"}},"selectors":{"{{WRAPPER}} .pxl-meta-box":"text-align: {{VALUE}};"}},{"name":"wg_max_width","label":"Widget Max Width","type":"slider","control_type":"responsive","size_units":["px","%"],"default":{"unit":"px"},"range":{"px":{"min":0,"max":3000},"%":{"min":0,"max":100}},"selectors":{"{{WRAPPER}} .pxl-meta-box":"max-width: {{SIZE}}{{UNIT}};"}},{"name":"img_width","label":"Image Width","type":"slider","control_type":"responsive","size_units":["px","%"],"default":{"unit":"px"},"range":{"px":{"min":0,"max":3000},"%":{"min":0,"max":100}},"selectors":{"{{WRAPPER}} .pxl-meta-box .pxl-item--image img":"width: {{SIZE}}{{UNIT}};"},"condition":{"layout":["2"]}},{"name":"img_height","label":"Image Height","type":"slider","control_type":"responsive","size_units":["px","%"],"default":{"unit":"px"},"range":{"px":{"min":0,"max":3000},"%":{"min":0,"max":100}},"selectors":{"{{WRAPPER}} .pxl-meta-box .pxl-item--image img":"height: {{SIZE}}{{UNIT}};"},"condition":{"layout":["2"]}},{"name":"content_max_width","label":"Content Max Width","type":"slider","control_type":"responsive","size_units":["px","%"],"default":{"unit":"px"},"range":{"px":{"min":0,"max":3000},"%":{"min":0,"max":100}},"selectors":{"{{WRAPPER}} .pxl-meta-box .pxl-item--content":"max-width: {{SIZE}}{{UNIT}};"}},{"name":"border_type","label":"Border Type","type":"select","options":{"":"None","solid":"Solid","double":"Double","dotted":"Dotted","dashed":"Dashed","groove":"Groove"},"selectors":{"{{WRAPPER}} .pxl-meta-box .pxl-item--inner":"border-style: {{VALUE}};"}},{"name":"border_width","label":"Border Width","type":"dimensions","selectors":{"{{WRAPPER}} .pxl-meta-box .pxl-item--inner":"border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"condition":{"border_type!":""},"responsive":true},{"name":"border_color","label":"Border Color","type":"color","default":"","selectors":{"{{WRAPPER}} .pxl-meta-box .pxl-item--inner":"border-color: {{VALUE}};"},"condition":{"border_type!":""}},{"name":"darkmode_border_color","label":"Border Color (Dark Mode)","type":"color","default":"","selectors":{".dark-mode .pxl-meta-box .pxl-item--inner":"border-color: {{VALUE}};"},"condition":{"border_type!":""}}]},{"name":"section_animation","label":"Animation","tab":"style","condition":[],"controls":[{"name":"pxl_animate","label":"Case Animate","type":"select","options":{"":"None","wow bounce":"bounce","wow flash":"flash","wow pulse":"pulse","wow rubberBand":"rubberBand","wow shake":"shake","wow swing":"swing","wow tada":"tada","wow wobble":"wobble","wow bounceIn":"bounceIn","wow bounceInDown":"bounceInDown","wow bounceInLeft":"bounceInLeft","wow bounceInRight":"bounceInRight","wow bounceInUp":"bounceInUp","wow bounceOut":"bounceOut","wow bounceOutDown":"bounceOutDown","wow bounceOutLeft":"bounceOutLeft","wow bounceOutRight":"bounceOutRight","wow bounceOutUp":"bounceOutUp","wow fadeIn":"fadeIn","wow fadeInDown":"fadeInDown","wow fadeInDownBig":"fadeInDownBig","wow fadeInLeft":"fadeInLeft","wow fadeInLeftBig":"fadeInLeftBig","wow fadeInRight":"fadeInRight","wow fadeInRightBig":"fadeInRightBig","wow fadeInUp":"fadeInUp","wow fadeInUpBig":"fadeInUpBig","wow fadeOut":"fadeOut","wow fadeOutDown":"fadeOutDown","wow fadeOutDownBig":"fadeOutDownBig","wow fadeOutLeft":"fadeOutLeft","wow fadeOutLeftBig":"fadeOutLeftBig","wow fadeOutRight":"fadeOutRight","wow fadeOutRightBig":"fadeOutRightBig","wow fadeOutUp":"fadeOutUp","wow fadeOutUpBig":"fadeOutUpBig","wow flip":"flip","wow flipInX":"flipInX","wow flipInY":"flipInY","wow flipOutX":"flipOutX","wow flipOutY":"flipOutY","wow lightSpeedIn":"lightSpeedIn","wow lightSpeedOut":"lightSpeedOut","wow rotateIn":"rotateIn","wow rotateInDownLeft":"rotateInDownLeft","wow rotateInDownRight":"rotateInDownRight","wow rotateInUpLeft":"rotateInUpLeft","wow rotateInUpRight":"rotateInUpRight","wow rotateOut":"rotateOut","wow rotateOutDownLeft":"rotateOutDownLeft","wow rotateOutDownRight":"rotateOutDownRight","wow rotateOutUpLeft":"rotateOutUpLeft","wow rotateOutUpRight":"rotateOutUpRight","wow hinge":"hinge","wow rollIn":"rollIn","wow rollOut":"rollOut","wow zoomIn":"zoomIn","wow zoomInDown":"zoomInDown","wow zoomInLeft":"zoomInLeft","wow zoomInRight":"zoomInRight","wow zoomInUp":"zoomInUp","wow zoomOut":"zoomOut","wow zoomOutDown":"zoomOutDown","wow zoomOutLeft":"zoomOutLeft","wow zoomOutRight":"zoomOutRight","wow zoomOutUp":"zoomOutUp"},"default":""},{"name":"pxl_animate_delay","label":"Animate Delay","type":"text","default":"0","description":"Enter number. Default 0ms"},{"name":"pxl_animate_duration","label":"Animation Duration","type":"number","min":0,"step":0.1000000000000000055511151231257827021181583404541015625,"default":1.1999999999999999555910790149937383830547332763671875,"description":"Default 1.2s"}]}]}';
    protected $styles = array(  );
    protected $scripts = array(  );
}