<?php

class PxlProductGrid_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_product_grid';
    protected $title = 'Product Grid Pxl';
    protected $icon = 'eicon-posts-grid';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"layout_section","label":"Layout","tab":"layout","controls":[{"name":"layout","label":"Templates","type":"layoutcontrol","default":"1","options":{"1":{"label":"Layout 1","image":"https:\/\/glansadesigns.com\/testing\/risenew\/wp-content\/themes\/agria\/elements\/templates\/pxl_product_grid\/img-layout\/layout1.jpg"},"2":{"label":"Layout 2","image":"https:\/\/glansadesigns.com\/testing\/risenew\/wp-content\/themes\/agria\/elements\/templates\/pxl_product_grid\/img-layout\/layout2.jpg"}},"prefix_class":"pxl-product-grid-layout-"}]},{"name":"source_section","label":"Source","tab":"content","controls":[{"name":"query_type","label":"Select Query Type","type":"select","default":"recent_product","options":{"recent_product":"Recent Products","best_selling":"Best Selling","featured_product":"Featured Products","top_rate":"High Rate","on_sale":"On Sale","recent_review":"Recent Review","deals":"Product Deals","separate":"Product separate"}},{"name":"taxonomies","label":"Select Term of Product","type":"select2","multiple":true,"options":{"clothing-accessory":"Clothing &amp; Accessory","food":"Food","nutrition":"Nutrition","personal-care":"Personal Care"}},{"name":"product_ids","label":"Products id (123,124,135...)","type":"text","default":"","condition":{"query_type":"separate"}},{"name":"post_per_page","label":"Post per page","type":"text","default":"12"}]},{"name":"general_section","label":"General Settings","tab":"content","controls":[{"name":"img_size","label":"Image Size","type":"text","description":"Enter image size (Example: \"thumbnail\", \"medium\", \"large\", \"full\" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height))."},{"name":"filter","label":"Term Filter","type":"select","default":"false","options":{"true":"Enable","false":"Disable"}},{"name":"filter_default_title","label":"Filter Default Title","type":"text","default":"All","condition":{"filter":"true"}},{"name":"filter_margin","label":"Filter Margin (px)","type":"dimensions","control_type":"responsive","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-product-grid .grid-filter-wrap":"margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"condition":{"filter":"true"}},{"name":"filter_item_margin","label":"Filter Item Margin","type":"dimensions","size_units":["px","%"],"default":{"unit":"%"},"range":{"%":{"min":0,"max":100},"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-grid .pxl-grid-filter .filter-item":"margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"control_type":"responsive","condition":{"filter":"true"}},{"name":"show_cursor_text","label":"Show Cursor Drag","type":"switcher","default":"false","condition":{"filter":"true"}},{"name":"cursor_text","label":"Cursor Text","type":"text","placeholder":"\u25c4 \u25ba","condition":{"filter":"true","show_cursor_text":"true"}},{"name":"pagination_type","label":"Pagination Type","type":"select","default":"false","options":{"pagination":"Pagination","loadmore":"Loadmore","false":"Disable"}},{"name":"loadmore_text","label":"Load More text","type":"text","default":"Load More","condition":{"pagination_type":"loadmore"}},{"name":"pagination_alignment","label":"Pagination Alignment","type":"choose","control_type":"responsive","options":{"start":{"title":"Start","icon":"eicon-text-align-left"},"center":{"title":"Center","icon":"eicon-text-align-center"},"end":{"title":"End","icon":"eicon-text-align-right"}},"selectors":{"{{WRAPPER}} .pxl-grid-pagination, {{WRAPPER}} .pxl-load-more":"justify-content: {{VALUE}};"},"condition":{"pagination_type!":"false"}},{"name":"item_padding","label":"Item Padding","type":"dimensions","size_units":["px"],"default":{"top":"20","right":"20","bottom":"20","left":"20"},"selectors":{"{{WRAPPER}} .pxl-grid-inner":"margin-top: -{{TOP}}{{UNIT}}; margin-right: -{{RIGHT}}{{UNIT}}; margin-bottom: -{{BOTTOM}}{{UNIT}}; margin-left: -{{LEFT}}{{UNIT}};","{{WRAPPER}} .pxl-grid-inner .pxl-grid-item":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"control_type":"responsive"},{"name":"gap_extra","label":"Item Gap Bottom","description":"Add extra space at bottom of each items","type":"number","default":0,"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-grid-inner .pxl-grid-item":"margin-bottom: {{VALUE}}px;"}},{"name":"item_animation","label":"Item Motion Effect","type":"animation","condition":[]},{"name":"item_animation_duration","label":"Item Animation Duration","type":"select","default":"normal","options":{"slow":"Slow","normal":"Normal","fast":"Fast"},"condition":{"item_animation!":""}},{"name":"item_animation_delay","label":"Item Animation Delay","type":"number","min":0,"step":100,"condition":{"item_animation!":""}}]},{"name":"grid_section","label":"Grid Settings","tab":"content","controls":[{"name":"col_xs","label":"Extra Small &lt;= 575","type":"select","default":"1","options":{"12":"12","6":"6","5":"5","4":"4","3":"3","2":"2","1":"1"}},{"name":"col_sm","label":"Small &lt;= 767","type":"select","default":"2","options":{"12":"12","6":"6","5":"5","4":"4","3":"3","2":"2","1":"1"}},{"name":"col_md","label":"Medium &lt;= 991","type":"select","default":"2","options":{"12":"12","6":"6","5":"5","4":"4","3":"3","2":"2","1":"1"}},{"name":"col_lg","label":"Large &lt;= 1199","type":"select","default":"3","options":{"12":"12","6":"6","5":"5","4":"4","3":"3","2":"2","1":"1"}},{"name":"col_xl","label":"XL Devices &gt;= 1200","type":"select","default":"4","options":{"12":"12","6":"6","5":"5","4":"4","3":"3","2":"2","1":"1"}},{"name":"col_xxl","label":"XXL Devices &gt;= 1400","type":"select","default":"4","options":{"12":"12","6":"6","5":"5","4":"4","3":"3","2":"2","1":"1"}}]},{"name":"style_section","label":"Style","tab":"style","controls":[{"name":"img_padding","label":"Image Padding","type":"dimensions","size_units":["px","%"],"control_type":"responsive","default":{"unit":"px"},"range":{"%":{"min":0,"max":300},"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-product-grid .woocommerce-product-inner .woocommerce-product-header .woocommerce-product-details":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"separator":"after"},{"name":"title_color","label":"Title Color","type":"color","selectors":{"{{WRAPPER}} .pxl-product-grid .woocommerce-product-content .woocommerce-product--title a":"color: {{VALUE}};"}},{"name":"darkmode_title_color","label":"Title Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-product-grid .woocommerce-product-content .woocommerce-product--title a":"color: {{VALUE}};"}},{"name":"hover_title_color","label":"Hover Title Color","type":"color","selectors":{"{{WRAPPER}} .pxl-product-grid .woocommerce-product-content .woocommerce-product--title a:hover":"color: {{VALUE}};"}},{"name":"darkmode_hover_title_color","label":"Hover Title Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-product-grid .woocommerce-product-content .woocommerce-product--title a:hover":"color: {{VALUE}};"}},{"name":"title_typography","label":"Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-product-grid .woocommerce-product-content .woocommerce-product--title"},{"name":"title_margin","label":"Title Margin","type":"dimensions","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-product-grid .woocommerce-product-content .woocommerce-product--title":"margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"control_type":"responsive","separator":"after"},{"name":"border_color","label":"Border Color","type":"color","selectors":{"{{WRAPPER}} .pxl-product-grid .woocommerce-product-inner:before":"border-color: {{VALUE}};"}},{"name":"darkmode_border_color","label":"Border Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-product-grid .woocommerce-product-inner:before":"border-color: {{VALUE}};"}},{"name":"bg_color","label":"Background Color","type":"color","selectors":{"{{WRAPPER}} .pxl-product-grid .woocommerce-product-inner":"background-color: {{VALUE}};"}},{"name":"darkmode_bg_color","label":"Background Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-product-grid .woocommerce-product-inner":"background-color: {{VALUE}};"}}]},{"name":"section_animation","label":"Animation","tab":"style","condition":[],"controls":[{"name":"pxl_animate","label":"Case Animate","type":"select","options":{"":"None","wow bounce":"bounce","wow flash":"flash","wow pulse":"pulse","wow rubberBand":"rubberBand","wow shake":"shake","wow swing":"swing","wow tada":"tada","wow wobble":"wobble","wow bounceIn":"bounceIn","wow bounceInDown":"bounceInDown","wow bounceInLeft":"bounceInLeft","wow bounceInRight":"bounceInRight","wow bounceInUp":"bounceInUp","wow bounceOut":"bounceOut","wow bounceOutDown":"bounceOutDown","wow bounceOutLeft":"bounceOutLeft","wow bounceOutRight":"bounceOutRight","wow bounceOutUp":"bounceOutUp","wow fadeIn":"fadeIn","wow fadeInDown":"fadeInDown","wow fadeInDownBig":"fadeInDownBig","wow fadeInLeft":"fadeInLeft","wow fadeInLeftBig":"fadeInLeftBig","wow fadeInRight":"fadeInRight","wow fadeInRightBig":"fadeInRightBig","wow fadeInUp":"fadeInUp","wow fadeInUpBig":"fadeInUpBig","wow fadeOut":"fadeOut","wow fadeOutDown":"fadeOutDown","wow fadeOutDownBig":"fadeOutDownBig","wow fadeOutLeft":"fadeOutLeft","wow fadeOutLeftBig":"fadeOutLeftBig","wow fadeOutRight":"fadeOutRight","wow fadeOutRightBig":"fadeOutRightBig","wow fadeOutUp":"fadeOutUp","wow fadeOutUpBig":"fadeOutUpBig","wow flip":"flip","wow flipInX":"flipInX","wow flipInY":"flipInY","wow flipOutX":"flipOutX","wow flipOutY":"flipOutY","wow lightSpeedIn":"lightSpeedIn","wow lightSpeedOut":"lightSpeedOut","wow rotateIn":"rotateIn","wow rotateInDownLeft":"rotateInDownLeft","wow rotateInDownRight":"rotateInDownRight","wow rotateInUpLeft":"rotateInUpLeft","wow rotateInUpRight":"rotateInUpRight","wow rotateOut":"rotateOut","wow rotateOutDownLeft":"rotateOutDownLeft","wow rotateOutDownRight":"rotateOutDownRight","wow rotateOutUpLeft":"rotateOutUpLeft","wow rotateOutUpRight":"rotateOutUpRight","wow hinge":"hinge","wow rollIn":"rollIn","wow rollOut":"rollOut","wow zoomIn":"zoomIn","wow zoomInDown":"zoomInDown","wow zoomInLeft":"zoomInLeft","wow zoomInRight":"zoomInRight","wow zoomInUp":"zoomInUp","wow zoomOut":"zoomOut","wow zoomOutDown":"zoomOutDown","wow zoomOutLeft":"zoomOutLeft","wow zoomOutRight":"zoomOutRight","wow zoomOutUp":"zoomOutUp"},"default":""},{"name":"pxl_animate_delay","label":"Animate Delay","type":"text","default":"0","description":"Enter number. Default 0ms"},{"name":"pxl_animate_duration","label":"Animation Duration","type":"number","min":0,"step":0.1000000000000000055511151231257827021181583404541015625,"default":1.1999999999999999555910790149937383830547332763671875,"description":"Default 1.2s"}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'imagesloaded','isotope','pxl-post-grid' );
}