<?php

class PxlCountdown_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_countdown';
    protected $title = 'Countdown Pxl';
    protected $icon = 'eicon-countdown';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"section_layout","label":"Layout","tab":"layout","controls":[{"name":"layout","label":"Templates","type":"layoutcontrol","default":"1","options":{"1":{"label":"Layout 1","image":"https:\/\/demo.bravisthemes.com\/agria\/wp-content\/themes\/agria\/elements\/templates\/pxl_countdown\/img-layout\/layout1.jpg"},"2":{"label":"Layout 2","image":"https:\/\/demo.bravisthemes.com\/agria\/wp-content\/themes\/agria\/elements\/templates\/pxl_countdown\/img-layout\/layout2.jpg"}}}]},{"name":"countdown_section","label":"Content","tab":"content","controls":[{"name":"title","label":"Title","type":"textarea","placeholder":"Enter your title","description":"Create highlight text width shortcode: [highlight text=\"Text Demo\"]","label_block":true,"condition":{"layout":["2"]}},{"name":"date","label":"Date","type":"text","default":"2040\/10\/10","placeholder":"yy\/mm\/dd","label_block":true,"description":"Set date count down (Date format: yy\/mm\/dd)"},{"name":"day","label":"Days Text","type":"text","placeholder":"Days","label_block":true},{"name":"hour","label":"Hours Text","type":"text","placeholder":"Hours","label_block":true},{"name":"minute","label":"Minutes Text","type":"text","placeholder":"Minutes","label_block":true},{"name":"second","label":"Seconds Text","type":"text","placeholder":"Seconds","label_block":true},{"name":"image","label":"Image","type":"media","condition":{"layout":["2"]}},{"name":"align","label":"Alignment","type":"choose","control_type":"responsive","options":{"left":{"title":"Left","icon":"eicon-text-align-left"},"center":{"title":"Center","icon":"eicon-text-align-center"},"right":{"title":"Right","icon":"eicon-text-align-right"},"justify":{"title":"Justified","icon":"eicon-text-align-justify"}},"selectors":{"{{WRAPPER}} .pxl-countdown-wrap":"text-align: {{VALUE}};"},"condition":{"layout":["2"]}}]},{"name":"section_style_title","label":"Title","tab":"style","condition":{"layout":["2"]},"controls":[{"name":"title_tag","label":"HTML Tag","type":"select","options":{"h1":"H1","h2":"H2","h3":"H3","h4":"H4","h5":"H5","h6":"H6","div":"div","span":"span","p":"p"},"default":"h5"},{"name":"title_color","label":"Title Color","type":"color","selectors":{"{{WRAPPER}} .pxl-countdown2 .pxl-item--title":"color: {{VALUE}};"}},{"name":"darkmode_title_color","label":"Title Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-countdown2 .pxl-item--title":"color: {{VALUE}};"}},{"name":"highlight_color","label":"Highlight Color","type":"color","selectors":{"{{WRAPPER}} .pxl-countdown2 .pxl-item--title .pxl-title--highlight":"color: {{VALUE}};"}},{"name":"darkmode_highlight_color","label":"Highlight Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-countdown2 .pxl-item--title .pxl-title--highlight":"color: {{VALUE}};"}},{"name":"title_typography","label":"Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-countdown2 .pxl-item--title"},{"name":"title_box_shadow","label":"Title Shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-countdown2 .pxl-item--title","condition":{"layout":["2"]}},{"name":"title_margin","label":"Margin (px)","type":"dimensions","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-countdown2 .pxl-item--title":"margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"control_type":"responsive","separator":"after"},{"name":"pxl_animate_title","label":"Case Animate","type":"select","options":{"":"None","wow letter":"Letter","wow bounce":"bounce","wow flash":"flash","wow pulse":"pulse","wow rubberBand":"rubberBand","wow shake":"shake","wow swing":"swing","wow tada":"tada","wow wobble":"wobble","wow bounceIn":"bounceIn","wow bounceInDown":"bounceInDown","wow bounceInLeft":"bounceInLeft","wow bounceInRight":"bounceInRight","wow bounceInUp":"bounceInUp","wow bounceOut":"bounceOut","wow bounceOutDown":"bounceOutDown","wow bounceOutLeft":"bounceOutLeft","wow bounceOutRight":"bounceOutRight","wow bounceOutUp":"bounceOutUp","wow fadeIn":"fadeIn","wow fadeInDown":"fadeInDown","wow fadeInDownBig":"fadeInDownBig","wow fadeInLeft":"fadeInLeft","wow fadeInLeftBig":"fadeInLeftBig","wow fadeInRight":"fadeInRight","wow fadeInRightBig":"fadeInRightBig","wow fadeInUp":"fadeInUp","wow fadeInUpBig":"fadeInUpBig","wow fadeOut":"fadeOut","wow fadeOutDown":"fadeOutDown","wow fadeOutDownBig":"fadeOutDownBig","wow fadeOutLeft":"fadeOutLeft","wow fadeOutLeftBig":"fadeOutLeftBig","wow fadeOutRight":"fadeOutRight","wow fadeOutRightBig":"fadeOutRightBig","wow fadeOutUp":"fadeOutUp","wow fadeOutUpBig":"fadeOutUpBig","wow flip":"flip","wow flipInX":"flipInX","wow flipInY":"flipInY","wow flipOutX":"flipOutX","wow flipOutY":"flipOutY","wow lightSpeedIn":"lightSpeedIn","wow lightSpeedOut":"lightSpeedOut","wow rotateIn":"rotateIn","wow rotateInDownLeft":"rotateInDownLeft","wow rotateInDownRight":"rotateInDownRight","wow rotateInUpLeft":"rotateInUpLeft","wow rotateInUpRight":"rotateInUpRight","wow rotateOut":"rotateOut","wow rotateOutDownLeft":"rotateOutDownLeft","wow rotateOutDownRight":"rotateOutDownRight","wow rotateOutUpLeft":"rotateOutUpLeft","wow rotateOutUpRight":"rotateOutUpRight","wow hinge":"hinge","wow rollIn":"rollIn","wow rollOut":"rollOut","wow zoomIn":"zoomIn","wow zoomInDown":"zoomInDown","wow zoomInLeft":"zoomInLeft","wow zoomInRight":"zoomInRight","wow zoomInUp":"zoomInUp","wow zoomOut":"zoomOut","wow zoomOutDown":"zoomOutDown","wow zoomOutLeft":"zoomOutLeft","wow zoomOutRight":"zoomOutRight","wow zoomOutUp":"zoomOutUp"},"default":""},{"name":"pxl_animate_delay_title","label":"Animate Delay","type":"text","default":"0","description":"Enter number. Default 0ms"},{"name":"pxl_animate_duration_title","label":"Animation Duration","type":"number","min":0,"step":0.1000000000000000055511151231257827021181583404541015625,"default":1.1999999999999999555910790149937383830547332763671875,"description":"Default 1.2s"}]},{"name":"section_style_countdown","label":"Countdown","tab":"style","controls":[{"name":"show_svg","label":"Pipe","type":"select","options":{"svg-on":"Show","svg-off":"Hidden"},"default":"svg-off","condition":{"layout":["1"]}},{"name":"countdown_color","label":"Number Color","type":"color","selectors":{"{{WRAPPER}} .countdown-item .countdown-amount":"color: {{VALUE}};"}},{"name":"darkmode_countdown_color","label":"Number Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .countdown-item .countdown-amount":"color: {{VALUE}};"}},{"name":"number_typography","label":"Number Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .countdown-item .countdown-amount"},{"name":"period_color","label":"Period Color","type":"color","selectors":{"{{WRAPPER}} .countdown-item .countdown-period":"color: {{VALUE}};"}},{"name":"darkmode_period_color","label":"Period Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .countdown-item .countdown-period":"color: {{VALUE}};"}},{"name":"period_typography","label":"Period Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .countdown-item .countdown-period"},{"name":"dot_color","label":"Dot Color","type":"color","selectors":{"{{WRAPPER}} .countdown-item:after":"color: {{VALUE}};"},"condition":{"show_svg":"svg-off"}},{"name":"darkmode_dot_color","label":"Dot Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .countdown-item:after":"color: {{VALUE}};"},"condition":{"show_svg":"svg-off"}},{"name":"dot_size","label":"Dot Size (px)","type":"slider","range":{"px":{"min":15,"max":300}},"condition":{"show_svg":"svg-off"},"selectors":{"{{WRAPPER}} .countdown-item:after":"font-size: {{SIZE}}{{UNIT}};"}},{"name":"svg_color","label":"SVG Color","type":"color","selectors":{"{{WRAPPER}} .countdown-item-inner svg":"fill: {{VALUE}};"},"condition":{"show_svg":"svg-on"}},{"name":"darkmode_svg_color","label":"SVG Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .countdown-item-inner svg":"fill: {{VALUE}};"},"condition":{"show_svg":"svg-on"}},{"name":"svg_size","label":"SVG Size","type":"slider","control_type":"responsive","size_units":["px","%"],"range":{"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .countdown-item-inner":"width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; min-width: {{SIZE}}{{UNIT}}; border-radius: {{SIZE}}{{UNIT}};"},"condition":{"show_svg":"svg-on"},"separator":"after"},{"name":"countdown_bg_color","label":"Countdown Background Color","type":"color","selectors":{"{{WRAPPER}} .pxl-countdown":"background-color: {{VALUE}};"}},{"name":"darkmode_countdown_bg_color","label":"Countdown Background Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-countdown":"background-color: {{VALUE}};"}},{"name":"countdown_padding","label":"Countdown Padding","type":"dimensions","control_type":"responsive","size_units":["px","%"],"default":{"unit":"px"},"range":{"px":{"min":0,"max":3000},"%":{"min":0,"max":100}},"selectors":{"{{WRAPPER}} .pxl-countdown":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"c_width","label":"Max Width","type":"slider","control_type":"responsive","size_units":["px","%"],"range":{"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-countdown-wrap .pxl-countdown":"max-width: {{SIZE}}{{UNIT}};"},"separator":"after"},{"name":"pxl_animate","label":"Case Animate","type":"select","options":{"":"None","wow letter":"Letter","wow bounce":"bounce","wow flash":"flash","wow pulse":"pulse","wow rubberBand":"rubberBand","wow shake":"shake","wow swing":"swing","wow tada":"tada","wow wobble":"wobble","wow bounceIn":"bounceIn","wow bounceInDown":"bounceInDown","wow bounceInLeft":"bounceInLeft","wow bounceInRight":"bounceInRight","wow bounceInUp":"bounceInUp","wow bounceOut":"bounceOut","wow bounceOutDown":"bounceOutDown","wow bounceOutLeft":"bounceOutLeft","wow bounceOutRight":"bounceOutRight","wow bounceOutUp":"bounceOutUp","wow fadeIn":"fadeIn","wow fadeInDown":"fadeInDown","wow fadeInDownBig":"fadeInDownBig","wow fadeInLeft":"fadeInLeft","wow fadeInLeftBig":"fadeInLeftBig","wow fadeInRight":"fadeInRight","wow fadeInRightBig":"fadeInRightBig","wow fadeInUp":"fadeInUp","wow fadeInUpBig":"fadeInUpBig","wow fadeOut":"fadeOut","wow fadeOutDown":"fadeOutDown","wow fadeOutDownBig":"fadeOutDownBig","wow fadeOutLeft":"fadeOutLeft","wow fadeOutLeftBig":"fadeOutLeftBig","wow fadeOutRight":"fadeOutRight","wow fadeOutRightBig":"fadeOutRightBig","wow fadeOutUp":"fadeOutUp","wow fadeOutUpBig":"fadeOutUpBig","wow flip":"flip","wow flipInX":"flipInX","wow flipInY":"flipInY","wow flipOutX":"flipOutX","wow flipOutY":"flipOutY","wow lightSpeedIn":"lightSpeedIn","wow lightSpeedOut":"lightSpeedOut","wow rotateIn":"rotateIn","wow rotateInDownLeft":"rotateInDownLeft","wow rotateInDownRight":"rotateInDownRight","wow rotateInUpLeft":"rotateInUpLeft","wow rotateInUpRight":"rotateInUpRight","wow rotateOut":"rotateOut","wow rotateOutDownLeft":"rotateOutDownLeft","wow rotateOutDownRight":"rotateOutDownRight","wow rotateOutUpLeft":"rotateOutUpLeft","wow rotateOutUpRight":"rotateOutUpRight","wow hinge":"hinge","wow rollIn":"rollIn","wow rollOut":"rollOut","wow zoomIn":"zoomIn","wow zoomInDown":"zoomInDown","wow zoomInLeft":"zoomInLeft","wow zoomInRight":"zoomInRight","wow zoomInUp":"zoomInUp","wow zoomOut":"zoomOut","wow zoomOutDown":"zoomOutDown","wow zoomOutLeft":"zoomOutLeft","wow zoomOutRight":"zoomOutRight","wow zoomOutUp":"zoomOutUp"},"default":""},{"name":"pxl_animate_delay","label":"Animate Delay","type":"text","default":"0","description":"Enter number. Default 0ms"},{"name":"pxl_animate_duration","label":"Animation Duration","type":"number","min":0,"step":0.1000000000000000055511151231257827021181583404541015625,"default":1.1999999999999999555910790149937383830547332763671875,"description":"Default 1.2s"}]},{"name":"section_style_box","label":"Box","tab":"style","controls":[{"name":"border_color","label":"Border Color","type":"color","selectors":{"{{WRAPPER}} .pxl-countdown-wrap":"border-color: {{VALUE}};"}},{"name":"darkmode_border_color","label":"Border Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-countdown-wrap":"border-color: {{VALUE}};"}},{"name":"box_padding","label":"Box Padding","type":"dimensions","control_type":"responsive","size_units":["px","%"],"default":{"unit":"px"},"range":{"px":{"min":0,"max":3000},"%":{"min":0,"max":100}},"selectors":{"{{WRAPPER}} .pxl-countdown-wrap":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'agria-countdown' );
}