<?php

class PxlImage_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_image';
    protected $title = 'Image Pxl';
    protected $icon = 'eicon-image';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"section_layout","label":"Layout","tab":"layout","controls":[{"name":"layout","label":"Templates","type":"layoutcontrol","default":"1","options":{"1":{"label":"Layout 1","image":"https:\/\/demo.bravisthemes.com\/agria\/wp-content\/themes\/agria\/elements\/templates\/pxl_image\/img-layout\/layout1.jpg"}}}]},{"name":"section_content","label":"Content","tab":"content","controls":[{"name":"image","label":"Choose Image","type":"media"},{"name":"image_link","label":"Link","type":"url"},{"name":"image_type","label":"Image Type","type":"select","options":{"img":"Image","bg":"Background"},"default":"img","condition":{"layout":["1"]}},{"name":"img_size","label":"Image Size","type":"text","description":"Enter image size (Example: &quot;thumbnail&quot;, &quot;medium&quot;, &quot;large&quot;, &quot;full&quot; or other sizes defined by theme). Alternatively enter size in pixels (Example: 200x100 (Width x Height).","condition":{"image_type":"img"}},{"name":"image_align","label":"Image Alignment","type":"choose","control_type":"responsive","options":{"left":{"title":"Left","icon":"fa fa-align-left"},"center":{"title":"Center","icon":"fa fa-align-center"},"right":{"title":"Right","icon":"fa fa-align-right"}},"selectors":{"{{WRAPPER}} .pxl-image-single":"text-align: {{VALUE}};"},"condition":{"layout":["1"]}}]},{"name":"section_style","label":"Image","tab":"style","controls":[{"name":"image_width","label":"Image Width","type":"slider","description":"Enter number.","control_type":"responsive","size_units":["px","%"],"default":{"unit":"px"},"range":{"px":{"min":0,"max":3000},"%":{"min":0,"max":100}},"condition":{"image_type":"img"},"selectors":{"{{WRAPPER}} .pxl-image-single img":"width: {{SIZE}}{{UNIT}};"}},{"name":"image_height","label":"Image Height","type":"slider","description":"Enter number.","control_type":"responsive","size_units":["px","%"],"default":{"unit":"px"},"range":{"px":{"min":0,"max":3000},"%":{"min":0,"max":100}},"condition":{"image_type":"img"},"selectors":{"{{WRAPPER}} .pxl-image-single img":"height: {{SIZE}}{{UNIT}};"}},{"name":"bg_height","label":"Image Height","type":"slider","description":"Enter number.","range":{"px":{"min":0,"max":3000}},"control_type":"responsive","condition":{"image_type":"bg"},"selectors":{"{{WRAPPER}} .pxl-image-single .pxl-image-bg":"height: {{SIZE}}{{UNIT}};"}},{"name":"image_size","label":"Image Size","type":"choose","control_type":"responsive","options":{"100%":{"title":"100%","icon":"eicon-text-align-justify"},"auto":{"title":"Auto","icon":"eicon-h-align-stretch"}},"selectors":{"{{WRAPPER}} .pxl-image-single img, {{WRAPPER}} .pxl-image-single .pxl-item--inner":"width: {{VALUE}};"}},{"name":"image_aspect_ratio","label":"Aspect Ratio","type":"text","description":"Enter value (Example: &quot;auto&quot;, &quot;1\/1&quot;, &quot;2\/1&quot;, &quot;16\/9&quot; or other sizes).","control_type":"responsive","condition":{"image_type":"img"},"selectors":{"{{WRAPPER}} .pxl-image-single img":"aspect-ratio: {{VALUE}};"}},{"name":"object_fit","label":"Size","type":"select","options":{"":"Default","none":"None","cover":"Cover","contain":"Contain","fill":"Fill"},"selectors":{"{{WRAPPER}} .pxl-image-single img":"object-fit: {{VALUE}};"},"condition":{"image_type":"img"}},{"name":"image_position","label":"Position","type":"select","control_type":"responsive","options":{"":"Default","relative":"Relative","absolute":"Absolute"},"default":"","separator":"before","selectors":{"{{WRAPPER}}":"position: {{VALUE}};"}},{"name":"img_horizontal_orientation","label":"Horizontal Orientation","type":"choose","control_type":"responsive","options":{"start":{"title":"Left","icon":"eicon-h-align-left"},"end":{"title":"Right","icon":"eicon-h-align-right"}},"toggle":false,"default":"start","render_type":"ui","condition":{"image_position!":""}},{"name":"image_offset_x","label":"Offset X","type":"slider","control_type":"responsive","range":{"px":{"min":-1000,"max":1000,"step":1},"%":{"min":-200,"max":200},"vw":{"min":-200,"max":200},"vh":{"min":-200,"max":200}},"default":{"size":"0"},"size_units":["px","%","vw","vh"],"selectors":{"{{WRAPPER}}":"left: {{SIZE}}{{UNIT}}"},"condition":{"img_horizontal_orientation":"start","image_position!":""}},{"name":"image_offset_x_end","label":"Offset X","type":"slider","control_type":"responsive","range":{"px":{"min":-1000,"max":1000,"step":1},"%":{"min":-200,"max":200},"vw":{"min":-200,"max":200},"vh":{"min":-200,"max":200}},"default":{"size":"0"},"size_units":["px","%","vw","vh"],"selectors":{"{{WRAPPER}}":"right: {{SIZE}}{{UNIT}}"},"condition":{"img_horizontal_orientation":"end","image_position!":""}},{"name":"img_vertical_orientation","label":"Vertical Orientation","type":"choose","control_type":"responsive","options":{"start":{"title":"Top","icon":"eicon-v-align-top"},"end":{"title":"Bottom","icon":"eicon-v-align-bottom"}},"toggle":false,"default":"start","render_type":"ui","condition":{"image_position!":""}},{"name":"image_offset_y","label":"Offset Y","type":"slider","control_type":"responsive","range":{"px":{"min":-1000,"max":1000,"step":1},"%":{"min":-200,"max":200},"vw":{"min":-200,"max":200},"vh":{"min":-200,"max":200}},"default":{"size":"0"},"size_units":["px","%","vw","vh"],"selectors":{"{{WRAPPER}}":"top: {{SIZE}}{{UNIT}}"},"condition":{"img_vertical_orientation":"start","image_position!":""}},{"name":"image_offset_y_end","label":"Offset Y","type":"slider","control_type":"responsive","range":{"px":{"min":-1000,"max":1000,"step":1},"%":{"min":-200,"max":200},"vw":{"min":-200,"max":200},"vh":{"min":-200,"max":200}},"default":{"size":"0"},"size_units":["px","%","vw","vh"],"selectors":{"{{WRAPPER}}":"bottom: {{SIZE}}{{UNIT}}"},"condition":{"img_vertical_orientation":"end","image_position!":""}},{"name":"img_border_radius","label":"Image Radius","type":"dimensions","control_type":"responsive","size_units":["px","%"],"default":{"unit":"%"},"range":{"px":{"min":0,"max":100},"%":{"min":0,"max":100}},"selectors":{"{{WRAPPER}} .pxl-image-single img":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"overlay_color","label":"Overlay Color","type":"color","selectors":{"{{WRAPPER}} .pxl-image-single .pxl-item--inner:before":"background-color: {{VALUE}};"}},{"name":"overlay_opacity","label":"Overlay Opacity","type":"slider","control_type":"responsive","range":{"px":{"min":0,"max":9}},"selectors":{"{{WRAPPER}} .pxl-image-single .pxl-item--inner:before":"opacity: 0.{{SIZE}};"}},{"name":"darkmode_overlay_color","label":"Overlay Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-image-single .pxl-item--inner:before":"background-color: {{VALUE}};"}},{"name":"darkmode_overlay-opacity","label":"Overlay Opacity (Dark Mode)","type":"slider","control_type":"responsive","range":{"px":{"min":0,"max":9}},"selectors":{".dark-mode {{WRAPPER}} .pxl-image-single .pxl-item--inner:before":"opacity: 0.{{SIZE}};"},"separator":"after"},{"name":"border_type","label":"Border Type","type":"select","options":{"":"None","solid":"Solid","double":"Double","dotted":"Dotted","dashed":"Dashed","groove":"Groove"},"selectors":{"{{WRAPPER}} .pxl-image-single img":"border-style: {{VALUE}};"}},{"name":"border_width","label":"Border Width","type":"dimensions","selectors":{"{{WRAPPER}} .pxl-image-single img":"border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"condition":{"border_type!":""},"responsive":true},{"name":"border_color","label":"Border Color","type":"color","default":"","selectors":{"{{WRAPPER}} .pxl-image-single img":"border-color: {{VALUE}};"},"condition":{"border_type!":""}},{"name":"darkmode_border_color","label":"Border Color (Dark Mode)","type":"color","default":"","selectors":{".dark-mode {{WRAPPER}} .pxl-image-single img":"border-color: {{VALUE}};"},"condition":{"border_type!":""}},{"name":"img_effect","label":"Image Effect","type":"select","options":{"":"None","pxl-image-ink":"Ink","pxl-image-scroller":"Scroll Load","pxl-image-effect1":"Zigzag","pxl-image-tilt":"Tilt","slide-top-to-bottom":"Slide Top To Bottom ","pxl-image-effect2":"Slide Bottom To Top ","slide-right-to-left":"Slide Right To Left ","slide-left-to-right":"Slide Left To Right "},"default":"","condition":{"image_type":"img","layout":["1"]}}]},{"name":"section_particle","label":"Particle","tab":"style","controls":[{"name":"show_particle","label":"Show Particle","type":"switcher","default":"false"},{"name":"particle_bottom_position","label":"Particle Bottom Position","type":"slider","size_units":["px","%"],"control_type":"responsive","default":{"unit":"%"},"range":{"%":{"min":0,"max":100},"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-circle--shapes":"bottom: {{SIZE}}{{UNIT}};"}},{"name":"particle_right_position","label":"Particle Right Position","type":"slider","size_units":["px","%"],"control_type":"responsive","default":{"unit":"%"},"range":{"%":{"min":0,"max":100},"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-circle--shapes":"right: {{SIZE}}{{UNIT}};"}},{"name":"width_particle","label":"Particle Width","type":"slider","size_units":["%","px"],"control_type":"responsive","default":{"unit":"%"},"range":{"%":{"min":0,"max":1000},"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-circle--shapes":"width: {{SIZE}}{{UNIT}};"}},{"name":"height_particle","label":"Particle Height","type":"slider","size_units":["%","px"],"control_type":"responsive","default":{"unit":"%"},"range":{"%":{"min":0,"max":1000},"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-circle--shapes":"height: {{SIZE}}{{UNIT}};"}},{"name":"particle_color","label":"Particle Color","type":"color","selectors":{"{{WRAPPER}} .pxl-circle--shapes":"border-color: {{VALUE}};"}},{"name":"darkmode_particle_color","label":"Particle Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-circle--shapes":"border-color: {{VALUE}};"}},{"name":"particle_size","label":"Particle Size (px)","type":"slider","control_type":"responsive","range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-circle--shapes":"border-width: {{SIZE}}{{UNIT}};"}}]},{"name":"section_animation","label":"Animation","tab":"style","condition":[],"controls":[{"name":"pxl_animate","label":"Case Animate","type":"select","options":{"":"None","wow bounce":"bounce","wow flash":"flash","wow pulse":"pulse","wow rubberBand":"rubberBand","wow shake":"shake","wow swing":"swing","wow tada":"tada","wow wobble":"wobble","wow bounceIn":"bounceIn","wow bounceInDown":"bounceInDown","wow bounceInLeft":"bounceInLeft","wow bounceInRight":"bounceInRight","wow bounceInUp":"bounceInUp","wow bounceOut":"bounceOut","wow bounceOutDown":"bounceOutDown","wow bounceOutLeft":"bounceOutLeft","wow bounceOutRight":"bounceOutRight","wow bounceOutUp":"bounceOutUp","wow fadeIn":"fadeIn","wow fadeInDown":"fadeInDown","wow fadeInDownBig":"fadeInDownBig","wow fadeInLeft":"fadeInLeft","wow fadeInLeftBig":"fadeInLeftBig","wow fadeInRight":"fadeInRight","wow fadeInRightBig":"fadeInRightBig","wow fadeInUp":"fadeInUp","wow fadeInUpBig":"fadeInUpBig","wow fadeOut":"fadeOut","wow fadeOutDown":"fadeOutDown","wow fadeOutDownBig":"fadeOutDownBig","wow fadeOutLeft":"fadeOutLeft","wow fadeOutLeftBig":"fadeOutLeftBig","wow fadeOutRight":"fadeOutRight","wow fadeOutRightBig":"fadeOutRightBig","wow fadeOutUp":"fadeOutUp","wow fadeOutUpBig":"fadeOutUpBig","wow flip":"flip","wow flipInX":"flipInX","wow flipInY":"flipInY","wow flipOutX":"flipOutX","wow flipOutY":"flipOutY","wow lightSpeedIn":"lightSpeedIn","wow lightSpeedOut":"lightSpeedOut","wow rotateIn":"rotateIn","wow rotateInDownLeft":"rotateInDownLeft","wow rotateInDownRight":"rotateInDownRight","wow rotateInUpLeft":"rotateInUpLeft","wow rotateInUpRight":"rotateInUpRight","wow rotateOut":"rotateOut","wow rotateOutDownLeft":"rotateOutDownLeft","wow rotateOutDownRight":"rotateOutDownRight","wow rotateOutUpLeft":"rotateOutUpLeft","wow rotateOutUpRight":"rotateOutUpRight","wow hinge":"hinge","wow rollIn":"rollIn","wow rollOut":"rollOut","wow zoomIn":"zoomIn","wow zoomInDown":"zoomInDown","wow zoomInLeft":"zoomInLeft","wow zoomInRight":"zoomInRight","wow zoomInUp":"zoomInUp","wow zoomOut":"zoomOut","wow zoomOutDown":"zoomOutDown","wow zoomOutLeft":"zoomOutLeft","wow zoomOutRight":"zoomOutRight","wow zoomOutUp":"zoomOutUp"},"default":""},{"name":"pxl_animate_delay","label":"Animate Delay","type":"text","default":"0","description":"Enter number. Default 0ms"},{"name":"pxl_animate_duration","label":"Animation Duration","type":"number","min":0,"step":0.1000000000000000055511151231257827021181583404541015625,"default":1.1999999999999999555910790149937383830547332763671875,"description":"Default 1.2s"}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'tilt','agria-img-effects' );
}