<?php

class PxlTeamGrid_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_team_grid';
    protected $title = 'Team Grid Pxl';
    protected $icon = 'eicon-person';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"section_layout","label":"Layout","tab":"layout","controls":[{"name":"layout","label":"Templates","type":"layoutcontrol","default":"1","options":{"1":{"label":"Layout 1","image":"https:\/\/demo.bravisthemes.com\/agria\/wp-content\/themes\/agria\/elements\/templates\/pxl_team_grid\/img-layout\/layout1.jpg"}}}]},{"name":"section_content","label":"Content","tab":"content","condition":{"layout":"1"},"controls":[{"name":"team","label":"Team","type":"repeater","default":[],"controls":[{"name":"image","label":"Image","type":"media"},{"name":"title","label":"Name","type":"text","label_block":true},{"name":"position","label":"Position","type":"text"},{"name":"link","label":"Link","type":"url","label_block":true},{"name":"social","label":"Social","type":"pxl_icons"}],"title_field":"{{{ title }}}"}]},{"name":"section_settings","label":"Grid","tab":"settings","controls":[{"name":"img_size","label":"Image Size","type":"text","description":"Enter image size (Example: \"thumbnail\", \"medium\", \"large\", \"full\" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height))."},{"name":"pxl_animate","label":"Pxl Animate","type":"select","options":{"":"None","wow bounce":"bounce","wow flash":"flash","wow pulse":"pulse","wow rubberBand":"rubberBand","wow shake":"shake","wow swing":"swing","wow tada":"tada","wow wobble":"wobble","wow bounceIn":"bounceIn","wow bounceInDown":"bounceInDown","wow bounceInLeft":"bounceInLeft","wow bounceInRight":"bounceInRight","wow bounceInUp":"bounceInUp","wow bounceOut":"bounceOut","wow bounceOutDown":"bounceOutDown","wow bounceOutLeft":"bounceOutLeft","wow bounceOutRight":"bounceOutRight","wow bounceOutUp":"bounceOutUp","wow fadeIn":"fadeIn","wow fadeInDown":"fadeInDown","wow fadeInDownBig":"fadeInDownBig","wow fadeInLeft":"fadeInLeft","wow fadeInLeftBig":"fadeInLeftBig","wow fadeInRight":"fadeInRight","wow fadeInRightBig":"fadeInRightBig","wow fadeInUp":"fadeInUp","wow fadeInUpBig":"fadeInUpBig","wow fadeOut":"fadeOut","wow fadeOutDown":"fadeOutDown","wow fadeOutDownBig":"fadeOutDownBig","wow fadeOutLeft":"fadeOutLeft","wow fadeOutLeftBig":"fadeOutLeftBig","wow fadeOutRight":"fadeOutRight","wow fadeOutRightBig":"fadeOutRightBig","wow fadeOutUp":"fadeOutUp","wow fadeOutUpBig":"fadeOutUpBig","wow flip":"flip","wow flipInX":"flipInX","wow flipInY":"flipInY","wow flipOutX":"flipOutX","wow flipOutY":"flipOutY","wow lightSpeedIn":"lightSpeedIn","wow lightSpeedOut":"lightSpeedOut","wow rotateIn":"rotateIn","wow rotateInDownLeft":"rotateInDownLeft","wow rotateInDownRight":"rotateInDownRight","wow rotateInUpLeft":"rotateInUpLeft","wow rotateInUpRight":"rotateInUpRight","wow rotateOut":"rotateOut","wow rotateOutDownLeft":"rotateOutDownLeft","wow rotateOutDownRight":"rotateOutDownRight","wow rotateOutUpLeft":"rotateOutUpLeft","wow rotateOutUpRight":"rotateOutUpRight","wow hinge":"hinge","wow rollIn":"rollIn","wow rollOut":"rollOut","wow zoomIn":"zoomIn","wow zoomInDown":"zoomInDown","wow zoomInLeft":"zoomInLeft","wow zoomInRight":"zoomInRight","wow zoomInUp":"zoomInUp","wow zoomOut":"zoomOut","wow zoomOutDown":"zoomOutDown","wow zoomOutLeft":"zoomOutLeft","wow zoomOutRight":"zoomOutRight","wow zoomOutUp":"zoomOutUp"},"default":""},{"name":"col_xs","label":"Columns XS Devices","type":"select","default":"1","options":{"1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"col_sm","label":"Columns SM Devices","type":"select","default":"2","options":{"1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"col_md","label":"Columns MD Devices","type":"select","default":"2","options":{"1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"col_lg","label":"Columns LG Devices","type":"select","default":"3","options":{"1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"col_xl","label":"Columns XL Devices","type":"select","default":"3","options":{"1":"1","2":"2","3":"3","4":"4","5":"5","6":"6"}},{"name":"item_padding","label":"Item Padding","type":"dimensions","size_units":["px"],"default":{"top":"20","right":"20","bottom":"20","left":"20"},"selectors":{"{{WRAPPER}} .pxl-grid-inner":"margin-top: -{{TOP}}{{UNIT}}; margin-right: -{{RIGHT}}{{UNIT}}; margin-bottom: -{{BOTTOM}}{{UNIT}}; margin-left: -{{LEFT}}{{UNIT}};","{{WRAPPER}} .pxl-grid-inner .pxl-grid-item":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"control_type":"responsive"},{"name":"gap_extra","label":"Item Gap Bottom","description":"Add extra space at bottom of each items","type":"number","default":0,"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-grid-inner .pxl-grid-item":"margin-bottom: {{VALUE}}px;"}}]},{"name":"section_style","label":"Style","tab":"style","controls":[{"name":"style","label":"Hover Image Effect","type":"select","options":{"style-circle":"Circle","style-overlay":"Overlay","none":"None"},"default":"style-circle"},{"name":"title_color","label":"Title Color","type":"color","selectors":{"{{WRAPPER}} .pxl-team-grid .pxl-item--title":"color: {{VALUE}};"}},{"name":"title_typography","label":"Title Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-team-grid .pxl-item--title"},{"name":"pos_color","label":"Position Color","type":"color","selectors":{"{{WRAPPER}} .pxl-team-grid .pxl-item--position":"color: {{VALUE}};"}},{"name":"pos_typography","label":"Position Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-team-grid .pxl-item--position"},{"name":"box_color","label":"Box Background Color","type":"color","selectors":{"{{WRAPPER}} .pxl-item--meta:before":"background-color: {{VALUE}};"}},{"name":"box_min_width","label":"Box Min Width","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-team-grid .pxl-item--meta":"min-width: {{SIZE}}{{UNIT}};"}},{"name":"icon_size","label":"Icon Size (px)","type":"slider","range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-team-grid .pxl-item--social a":"font-size: {{SIZE}}{{UNIT}};"}},{"name":"icon_color","label":"Icon Color","type":"color","selectors":{"{{WRAPPER}} .pxl-team-grid .pxl-item--social a i":"color: {{VALUE}};"}},{"name":"icon_color_hover","label":"Icon Color Hover","type":"color","selectors":{"{{WRAPPER}} .pxl-team-grid .pxl-item--social a:hover i":"color: {{VALUE}};"}},{"name":"icon_background_color","label":"Icon Background Color","type":"color","selectors":{"{{WRAPPER}} .pxl-team-grid .pxl-item--social a":"background-color: {{VALUE}};"}},{"name":"icon_background_color_hover","label":"Icon Background Color Hover","type":"color","selectors":{"{{WRAPPER}} .pxl-team-grid .pxl-item--social a span:before":"background-color: {{VALUE}};"}}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'imagesloaded','isotope','pxl-post-grid' );
}