<?php

class PxlVideoPlayer_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_video_player';
    protected $title = 'Video Player Pxl';
    protected $icon = 'eicon-play';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"section_content","label":"Content","tab":"content","controls":[{"name":"title","label":"Title","type":"text","label_block":true},{"name":"video_link","label":"Link","type":"text"},{"name":"image_type","label":"Image Type","type":"select","options":{"none":"None","img":"Image","bg":"Background"},"default":"none","condition":{"btn_video_style":["style1","style2"]}},{"name":"image","label":"Image","type":"media","condition":{"image_type":["img","bg"]}},{"name":"img_size","label":"Image Size","type":"text","description":"Enter image size (Example: \"thumbnail\", \"medium\", \"large\", \"full\" or other sizes defined by theme). Alternatively enter size in pixels (Example: 200x100 (Width x Height).","condition":{"image_type":"img"}},{"name":"img_width","label":"Image Width","type":"slider","description":"Enter number.","control_type":"responsive","size_units":["px","%"],"default":{"unit":"px"},"range":{"px":{"min":0,"max":3000},"%":{"min":0,"max":100}},"condition":{"image_type":"img"},"selectors":{"{{WRAPPER}} .pxl-video-player .pxl-video--holder img":"width: {{SIZE}}{{UNIT}};"}},{"name":"img_height","label":"Image Height","type":"slider","description":"Enter number.","control_type":"responsive","size_units":["px","%"],"default":{"unit":"px"},"range":{"px":{"min":0,"max":3000},"%":{"min":0,"max":100}},"condition":{"image_type":"img"},"selectors":{"{{WRAPPER}} .pxl-video-player .pxl-video--holder img":"height: {{SIZE}}{{UNIT}};"}},{"name":"image_height","label":"Image Height","type":"slider","description":"Enter number.","condition":{"image_type":"bg"},"range":{"px":{"min":0,"max":3000}},"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-video-player .pxl-video--image":"height: {{SIZE}}{{UNIT}};"}},{"name":"btn_video_style","label":"Button Video Style","type":"select","options":{"style1":"Style 1","style2":"Style 2","style3":"Style 3"},"default":"style1"},{"name":"btn_video_position","label":"Button Video Position","type":"select","options":{"p-center":"Center","p-top-left":"Top Left","p-top-right":"Top Right","p-bottom-left":"Bottom Left","p-bottom-right":"Bottom Right"},"default":"p-center","condition":{"image_type":["img","bg"]}},{"name":"top_position","label":"Top Position","type":"slider","size_units":["px","%"],"control_type":"responsive","default":{"size":0,"unit":"%"},"range":{"%":{"min":0,"max":100},"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-top-left, {{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-top-right":"top: {{SIZE}}{{UNIT}};"},"condition":{"btn_video_position":["p-top-left","p-top-right"]}},{"name":"right_position","label":"Right Position","type":"slider","size_units":["px","%"],"control_type":"responsive","default":{"size":0,"unit":"%"},"range":{"%":{"min":0,"max":100},"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-top-right, {{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-bottom-right":"right: {{SIZE}}{{UNIT}};"},"condition":{"btn_video_position":["p-top-right","p-bottom-right"]}},{"name":"bottom_position","label":"Bottom Position","type":"slider","size_units":["px","%"],"control_type":"responsive","default":{"size":0,"unit":"%"},"range":{"%":{"min":0,"max":100},"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-bottom-left, {{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-bottom-right":"bottom: {{SIZE}}{{UNIT}};"},"condition":{"btn_video_position":["p-bottom-left","p-bottom-right"]}},{"name":"left_position","label":"Left Position","type":"slider","size_units":["px","%"],"control_type":"responsive","default":{"size":0,"unit":"%"},"range":{"%":{"min":0,"max":100},"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-top-left, {{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-bottom-left":"left: {{SIZE}}{{UNIT}};"},"condition":{"btn_video_position":["p-top-left","p-bottom-left"]}}]},{"name":"section_style_content","label":"Content","tab":"style","controls":[{"name":"title_color","label":"Title Color","type":"color","selectors":{"{{WRAPPER}} .pxl-video-player .pxl-item--title":"color: {{VALUE}};"}},{"name":"darkmode_title_color","label":"Title Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-video-player .pxl-item--title":"color: {{VALUE}};"}},{"name":"title_typography","label":"Title Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-video-player .pxl-item--title"},{"name":"title_width","label":"Title Max Width","type":"slider","control_type":"responsive","size_units":["px","%"],"range":{"px":{"min":0,"max":3000},"%":{"min":0,"max":100}},"selectors":{"{{WRAPPER}} .pxl-video-player .pxl-item--title":"max-width: {{SIZE}}{{UNIT}};"}},{"name":"title_margin","label":"Title Margin (px)","type":"dimensions","control_type":"responsive","size_units":["px","%"],"default":{"unit":"px"},"range":{"px":{"min":0,"max":3000},"%":{"min":0,"max":100}},"selectors":{"{{WRAPPER}} .pxl-video-player .pxl-item--title":"margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"separator":"after"},{"name":"icon_color","label":"Icon Color","type":"color","selectors":{"{{WRAPPER}} .pxl-video-player .btn-video":"color: {{VALUE}};"}},{"name":"darkmode_icon_color","label":"Icon Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-video-player .btn-video i":"color: {{VALUE}};"}},{"name":"icon_size","label":"Icon Size (px)","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-video-player .btn-video i":"font-size: {{SIZE}}{{UNIT}};"}},{"name":"icon_width","label":"Icon Width (px)","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-video-player .btn-video":"width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};"}}]},{"name":"section_particle","label":"Particle","tab":"style","controls":[{"name":"show_particle","label":"Show Particle","type":"switcher","default":"false"},{"name":"particle_bottom_position","label":"Particle Bottom Position","type":"slider","size_units":["px","%"],"control_type":"responsive","default":{"unit":"%"},"range":{"%":{"min":0,"max":100},"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-circle--shapes":"bottom: {{SIZE}}{{UNIT}};"}},{"name":"particle_right_position","label":"Particle Right Position","type":"slider","size_units":["px","%"],"control_type":"responsive","default":{"unit":"%"},"range":{"%":{"min":0,"max":100},"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-circle--shapes":"right: {{SIZE}}{{UNIT}};"}},{"name":"width_particle","label":"Particle Width","type":"slider","size_units":["%","px"],"control_type":"responsive","default":{"unit":"%"},"range":{"%":{"min":0,"max":1000},"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-circle--shapes":"width: {{SIZE}}{{UNIT}};"}},{"name":"height_particle","label":"Particle Height","type":"slider","size_units":["%","px"],"control_type":"responsive","default":{"unit":"%"},"range":{"%":{"min":0,"max":1000},"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-circle--shapes":"height: {{SIZE}}{{UNIT}};"}},{"name":"particle_color","label":"Particle Color","type":"color","selectors":{"{{WRAPPER}} .pxl-circle--shapes":"border-color: {{VALUE}};"}},{"name":"darkmode_particle_color","label":"Particle Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-circle--shapes":"border-color: {{VALUE}};"}},{"name":"particle_size","label":"Particle Size (px)","type":"slider","control_type":"responsive","range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-circle--shapes":"border-width: {{SIZE}}{{UNIT}};"}}]},{"name":"section_style_box","label":"Box","tab":"style","controls":[{"name":"bg_position","label":"Background Position","type":"select","default":"","responsive":true,"options":{"":"Default","center center":"Center Center","center left":"Center Left","center right":"Center Right","top center":"Top Center","top left":"Top Left","top right":"Top Right","bottom center":"Bottom Center","bottom left":"Bottom Left","bottom right":"Bottom Right","initial":"Custom"},"selectors":{"{{WRAPPER}} .pxl-video--image":"background-position: {{VALUE}};"},"condition":{"image_type":"bg"}},{"name":"bg_position_xpos","label":"X Position","type":"slider","responsive":true,"size_units":["px","em","%","vw"],"default":{"unit":"px","size":0},"tablet_default":{"unit":"px","size":0},"mobile_default":{"unit":"px","size":0},"range":{"px":{"min":-800,"max":800},"em":{"min":-100,"max":100},"%":{"min":-100,"max":100},"vw":{"min":-100,"max":100}},"selectors":{"{{WRAPPER}} .pxl-video--image":"background-position: {{SIZE}}{{UNIT}} {{bg_position_ypos.SIZE}}{{bg_position_ypos.UNIT}}"},"condition":{"image_type":"bg","bg_position":["initial"]},"required":true},{"name":"bg_position_ypos","label":"Y Position","type":"slider","responsive":true,"size_units":["px","em","%","vw"],"default":{"unit":"px","size":0},"tablet_default":{"unit":"px","size":0},"mobile_default":{"unit":"px","size":0},"range":{"px":{"min":-800,"max":800},"em":{"min":-100,"max":100},"%":{"min":-100,"max":100},"vw":{"min":-100,"max":100}},"selectors":{"{{WRAPPER}} .pxl-video--image":"background-position: {{bg_position_xpos.SIZE}}{{bg_position_xpos.UNIT}} {{SIZE}}{{UNIT}}"},"condition":{"image_type":"bg","bg_position":["initial"]},"required":true},{"name":"bg_attachment","label":"Background Attachment","type":"select","default":"","options":{"":"Default","scroll":"Scroll","fixed":"Fixed"},"selectors":{"{{WRAPPER}} .pxl-video--image":"background-attachment: {{VALUE}};"},"condition":{"image_type":"bg"}},{"name":"bg_attachment_alert","type":"raw_html","content_classes":"elementor-control-field-description","raw":"Note: Attachment Fixed works only on desktop.","separator":"none","condition":{"image_type":"bg","bg_attachment":"fixed"}},{"name":"bg_repeat","label":"Background Repeat","type":"select","default":"","responsive":true,"options":{"":"Default","no-repeat":"No-repeat","repeat":"Repeat","repeat-x":"Repeat-x","repeat-y":"Repeat-y"},"selectors":{"{{WRAPPER}} .pxl-video--image":"background-repeat: {{VALUE}};"},"condition":{"image_type":"bg"}},{"name":"bg_size","label":"Background Size","type":"select","default":"","responsive":true,"options":{"":"Default","auto":"Auto","cover":"Cover","contain":"Contain","initial":"Custom"},"selectors":{"{{WRAPPER}} .pxl-video--image":"background-size: {{VALUE}};"},"condition":{"image_type":"bg"}},{"name":"bg_width","label":"Background Width","type":"slider","responsive":true,"size_units":["px","em","%","vw"],"range":{"px":{"min":0,"max":1000},"%":{"min":0,"max":100},"vw":{"min":0,"max":100}},"default":{"size":100,"unit":"%"},"required":true,"selectors":{"{{WRAPPER}} .pxl-video--image":"background-size: {{SIZE}}{{UNIT}} auto"},"condition":{"image_type":"bg","bg_size":["initial"]}},{"name":"box_bgcolor","label":"Background Color","type":"color","selectors":{"{{WRAPPER}} .pxl-video-player .btn-video":"background-color: {{VALUE}};"}},{"name":"darkmode_box_bgcolor","label":"Background Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-video-player .btn-video":"background-color: {{VALUE}};"}},{"name":"box_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","%"],"control_type":"responsive","default":{"unit":"px"},"range":{"%":{"min":0,"max":100},"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-video-player .pxl-video--holder":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"overlay_color","label":"Overlay Color","type":"color","selectors":{"{{WRAPPER}} .pxl-video-player .pxl-video--holder:before":"background-color: {{VALUE}};"}},{"name":"overlay-opacity","label":"Overlay Opacity","type":"slider","control_type":"responsive","range":{"px":{"min":0,"max":9}},"selectors":{"{{WRAPPER}} .pxl-video-player .pxl-video--holder:before":"opacity: 0.{{SIZE}};"},"separator":"after"},{"name":"darkmode_overlay_color","label":"Overlay Color (Dark Mode)","type":"color","selectors":{".dark-mode {{WRAPPER}} .pxl-video-player .pxl-video--holder:before":"background-color: {{VALUE}};"}},{"name":"darkmode_overlay-opacity","label":"Overlay Opacity (Dark Mode)","type":"slider","control_type":"responsive","range":{"px":{"min":0,"max":9}},"selectors":{".dark-mode {{WRAPPER}} .pxl-video-player .pxl-video--holder:before":"opacity: 0.{{SIZE}};"}},{"name":"object_fit","label":"Size","type":"select","options":{"":"Default","none":"None","cover":"Cover","contain":"Contain","fill":"Fill"},"selectors":{"{{WRAPPER}} .pxl-video--holder img":"object-fit: {{VALUE}};"},"condition":{"image_type":"img"}},{"name":"border_type","label":"Border Type","type":"select","options":{"":"None","solid":"Solid","double":"Double","dotted":"Dotted","dashed":"Dashed","groove":"Groove"},"selectors":{"{{WRAPPER}} .pxl-video--holder img":"border-style: {{VALUE}};"}},{"name":"border_width","label":"Border Width","type":"dimensions","selectors":{"{{WRAPPER}} .pxl-video--holder img":"border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"condition":{"border_type!":""},"responsive":true},{"name":"border_color","label":"Border Color","type":"color","default":"","selectors":{"{{WRAPPER}} .pxl-video--holder img":"border-color: {{VALUE}};"},"condition":{"border_type!":""}},{"name":"darkmode_border_color","label":"Border Color (Dark Mode)","type":"color","default":"","selectors":{".dark-mode {{WRAPPER}} .pxl-video--holder img":"border-color: {{VALUE}};"},"condition":{"border_type!":""}}]},{"name":"section_animation","label":"Animation","tab":"style","condition":[],"controls":[{"name":"pxl_animate","label":"Case Animate","type":"select","options":{"":"None","wow bounce":"bounce","wow flash":"flash","wow pulse":"pulse","wow rubberBand":"rubberBand","wow shake":"shake","wow swing":"swing","wow tada":"tada","wow wobble":"wobble","wow bounceIn":"bounceIn","wow bounceInDown":"bounceInDown","wow bounceInLeft":"bounceInLeft","wow bounceInRight":"bounceInRight","wow bounceInUp":"bounceInUp","wow bounceOut":"bounceOut","wow bounceOutDown":"bounceOutDown","wow bounceOutLeft":"bounceOutLeft","wow bounceOutRight":"bounceOutRight","wow bounceOutUp":"bounceOutUp","wow fadeIn":"fadeIn","wow fadeInDown":"fadeInDown","wow fadeInDownBig":"fadeInDownBig","wow fadeInLeft":"fadeInLeft","wow fadeInLeftBig":"fadeInLeftBig","wow fadeInRight":"fadeInRight","wow fadeInRightBig":"fadeInRightBig","wow fadeInUp":"fadeInUp","wow fadeInUpBig":"fadeInUpBig","wow fadeOut":"fadeOut","wow fadeOutDown":"fadeOutDown","wow fadeOutDownBig":"fadeOutDownBig","wow fadeOutLeft":"fadeOutLeft","wow fadeOutLeftBig":"fadeOutLeftBig","wow fadeOutRight":"fadeOutRight","wow fadeOutRightBig":"fadeOutRightBig","wow fadeOutUp":"fadeOutUp","wow fadeOutUpBig":"fadeOutUpBig","wow flip":"flip","wow flipInX":"flipInX","wow flipInY":"flipInY","wow flipOutX":"flipOutX","wow flipOutY":"flipOutY","wow lightSpeedIn":"lightSpeedIn","wow lightSpeedOut":"lightSpeedOut","wow rotateIn":"rotateIn","wow rotateInDownLeft":"rotateInDownLeft","wow rotateInDownRight":"rotateInDownRight","wow rotateInUpLeft":"rotateInUpLeft","wow rotateInUpRight":"rotateInUpRight","wow rotateOut":"rotateOut","wow rotateOutDownLeft":"rotateOutDownLeft","wow rotateOutDownRight":"rotateOutDownRight","wow rotateOutUpLeft":"rotateOutUpLeft","wow rotateOutUpRight":"rotateOutUpRight","wow hinge":"hinge","wow rollIn":"rollIn","wow rollOut":"rollOut","wow zoomIn":"zoomIn","wow zoomInDown":"zoomInDown","wow zoomInLeft":"zoomInLeft","wow zoomInRight":"zoomInRight","wow zoomInUp":"zoomInUp","wow zoomOut":"zoomOut","wow zoomOutDown":"zoomOutDown","wow zoomOutLeft":"zoomOutLeft","wow zoomOutRight":"zoomOutRight","wow zoomOutUp":"zoomOutUp"},"default":""},{"name":"pxl_animate_delay","label":"Animate Delay","type":"text","default":"0","description":"Enter number. Default 0ms"},{"name":"pxl_animate_duration","label":"Animation Duration","type":"number","min":0,"step":0.1000000000000000055511151231257827021181583404541015625,"default":1.1999999999999999555910790149937383830547332763671875,"description":"Default 1.2s"}]}]}';
    protected $styles = array(  );
    protected $scripts = array(  );
}